/*!
* Photo Sphere Viewer 4.5.3
* @copyright 2014-2015 Jérémy Heleine
* @copyright 2015-2022 Damien "Mistic" Sorel
* @licence MIT (https://opensource.org/licenses/MIT)
*/
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("three"),require("uevent")):"function"==typeof define&&define.amd?define(["exports","three","uevent"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).PhotoSphereViewer={},t.THREE,t.uEvent)}(this,(function(t,e,o){"use strict";var n=300,i=10,r="photoSphereViewer",s="psvSphere",a={ROTATE_LAT_UP:"rotateLatitudeUp",ROTATE_LAT_DOWN:"rotateLatitudeDown",ROTATE_LONG_RIGHT:"rotateLongitudeRight",ROTATE_LONG_LEFT:"rotateLongitudeLeft",ZOOM_IN:"zoomIn",ZOOM_OUT:"zoomOut",TOGGLE_AUTOROTATE:"toggleAutorotate"},c={AUTOROTATE:"autorotate",BEFORE_RENDER:"before-render",BEFORE_ROTATE:"before-rotate",CLICK:"click",CLOSE_PANEL:"close-panel",CONFIG_CHANGED:"config-changed",DOUBLE_CLICK:"dblclick",FULLSCREEN_UPDATED:"fullscreen-updated",HIDE_NOTIFICATION:"hide-notification",HIDE_OVERLAY:"hide-overlay",HIDE_TOOLTIP:"hide-tooltip",LOAD_PROGRESS:"load-progress",OPEN_PANEL:"open-panel",PANORAMA_LOADED:"panorama-loaded",POSITION_UPDATED:"position-updated",READY:"ready",RENDER:"render",SHOW_NOTIFICATION:"show-notification",SHOW_OVERLAY:"show-overlay",SHOW_TOOLTIP:"show-tooltip",SIZE_UPDATED:"size-updated",STOP_ALL:"stop-all",ZOOM_UPDATED:"zoom-updated"},h={GET_ANIMATE_POSITION:"get-animate-position",GET_ROTATE_POSITION:"get-rotate-position"},l={ENTER_OBJECT:"enter-object",HOVER_OBJECT:"hover-object",LEAVE_OBJECT:"leave-object"},p={MENU:"menu",TWO_FINGERS:"twoFingers",CTRL_ZOOM:"ctrlZoom",ERROR:"error"},u={linear:function(t){return t},inQuad:function(t){return t*t},outQuad:function(t){return t*(2-t)},inOutQuad:function(t){return t<.5?2*t*t:(4-2*t)*t-1},inCubic:function(t){return t*t*t},outCubic:function(t){return--t*t*t+1},inOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},inQuart:function(t){return t*t*t*t},outQuart:function(t){return 1- --t*t*t*t},inOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},inQuint:function(t){return t*t*t*t*t},outQuint:function(t){return 1+--t*t*t*t*t},inOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t},inSine:function(t){return 1-Math.cos(t*(Math.PI/2))},outSine:function(t){return Math.sin(t*(Math.PI/2))},inOutSine:function(t){return.5-.5*Math.cos(Math.PI*t)},inExpo:function(t){return Math.pow(2,10*(t-1))},outExpo:function(t){return 1-Math.pow(2,-10*t)},inOutExpo:function(t){return(t=2*t-1)<0?.5*Math.pow(2,10*t):1-.5*Math.pow(2,-10*t)},inCirc:function(t){return 1-Math.sqrt(1-t*t)},outCirc:function(t){return Math.sqrt(1-(t-1)*(t-1))},inOutCirc:function(t){return(t*=2)<1?.5-.5*Math.sqrt(1-t*t):.5+.5*Math.sqrt(1-(t-=2)*t)}},d={Enter:"Enter",Control:"Control",Escape:"Escape",Space:" ",PageUp:"PageUp",PageDown:"PageDown",ArrowLeft:"ArrowLeft",ArrowUp:"ArrowUp",ArrowRight:"ArrowRight",ArrowDown:"ArrowDown",Delete:"Delete",Plus:"+",Minus:"-"},v=Object.freeze({__proto__:null,DEFAULT_TRANSITION:1500,MOVE_THRESHOLD:4,DBLCLICK_DELAY:300,LONGTOUCH_DELAY:500,TWOFINGERSOVERLAY_DELAY:100,CTRLZOOM_TIMEOUT:2e3,INERTIA_WINDOW:n,SPHERE_RADIUS:i,VIEWER_DATA:r,MESH_USER_DATA:s,ACTIONS:a,EVENTS:c,CHANGE_EVENTS:h,OBJECT_EVENTS:l,IDS:p,EASINGS:u,KEY_CODES:d});function f(t,e,o){if(t.classList)void 0===o?t.classList.toggle(e):o&&!t.classList.contains(e)?t.classList.add(e):o||t.classList.remove(e);else{var n=t.getAttribute("class")||"",i=-1!==n.indexOf(e),r=new RegExp("(?:^|\\s)"+e+"(?:\\s|$)");void 0!==o&&!o||i?o||(n=n.replace(r," ")):n+=n.length>0?" "+e:e,t.setAttribute("class",n)}}function m(t,e){e&&e.split(" ").forEach((function(e){f(t,e,!0)}))}function g(t,e){var o=t.matches||t.msMatchesSelector,n=t;if(!o)return null;do{if(o.bind(n)(e))return n;n=n instanceof SVGElement?n.parentNode:n.parentElement}while(n);return null}function w(t){for(var e=0,o=0,n=t;n;)e+=n.offsetLeft-n.scrollLeft+n.clientLeft,o+=n.offsetTop-n.scrollTop+n.clientTop,n=n.offsetParent;return{left:e,top:o}}var _={13:"Enter",17:"Control",27:"Escape",32:" ",33:"PageUp",34:"PageDown",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",46:"Delete",107:"+",109:"-"},y={Add:"+",Del:"Delete",Down:"ArrowDown",Esc:"Escape",Left:"ArrowLeft",Right:"ArrowRight",Spacebar:" ",Subtract:"-",Up:"ArrowUp"};function E(t){var e=t.key||_[t.keyCode||t.which];return e&&y[e]&&(e=y[e]),e}function b(t){return(document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement)===t}function T(t){(t.requestFullscreen||t.mozRequestFullScreen||t.webkitRequestFullscreen||t.msRequestFullscreen).call(t)}function M(){(document.exitFullscreen||document.mozCancelFullScreen||document.webkitExitFullscreen||document.msExitFullscreen).call(document)}function O(t,e){return window.getComputedStyle(t,null)[e]}function L(t){var e=0,o=0,n=0,i=0;return"detail"in t&&(o=t.detail),"wheelDelta"in t&&(o=-t.wheelDelta/120),"wheelDeltaY"in t&&(o=-t.wheelDeltaY/120),"wheelDeltaX"in t&&(e=-t.wheelDeltaX/120),"axis"in t&&t.axis===t.HORIZONTAL_AXIS&&(e=o,o=0),n=10*e,i=10*o,"deltaY"in t&&(i=t.deltaY),"deltaX"in t&&(n=t.deltaX),(n||i)&&t.deltaMode&&(1===t.deltaMode?(n*=40,i*=40):(n*=800,i*=800)),n&&!e&&(e=n<1?-1:1),i&&!o&&(o=i<1?-1:1),{spinX:e,spinY:o,pixelX:n,pixelY:i}}function x(t,e,o){return Math.max(e,Math.min(o,t))}function C(t){return Math.log(t)/Math.log(2)%1==0}function A(t,e){return Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2))}function P(t,e){return[0,2*Math.PI,2*-Math.PI].reduce((function(o,n){var i=e-t+n;return Math.abs(i)<Math.abs(o)?i:o}),1/0)}function S(t,e){return Math.acos(Math.cos(t.latitude)*Math.cos(e.latitude)*Math.cos(t.longitude-e.longitude)+Math.sin(t.latitude)*Math.sin(e.latitude))}function k(t){return t.replace(/[A-Z](?:(?=[^A-Z])|[A-Z]*(?=[A-Z][^A-Z]|$))/g,(function(t,e){return(e>0?"-":"")+t.toLowerCase()}))}function D(t,e){var o,n,i,r,s=0,a=function(){s=Date.now(),r=void 0,i=t.apply(o,n),r||(o=n=null)};return function(){var c=Date.now();s||(s=c);var h=e-(c-s);return o=this,n=arguments,h<=0||h>e?(r&&(clearTimeout(r),r=void 0),s=c,i=t.apply(o,n),r||(o=n=null)):r||(r=setTimeout(a,h)),i}}function I(t){if("object"==typeof t&&null!==t){if("function"==typeof Object.getPrototypeOf){var e=Object.getPrototypeOf(t);return e===Object.prototype||null===e}return"[object Object]"===Object.prototype.toString.call(t)}return!1}function H(t,e){var o=e;return function t(e,n){return Array.isArray(n)?(e&&Array.isArray(e)?e.length=0:e=[],n.forEach((function(o,n){e[n]=t(null,o)}))):"object"==typeof n?(e&&!Array.isArray(e)||(e={}),Object.keys(n).forEach((function(i){"object"==typeof n[i]&&n[i]&&I(n[i])?n[i]!=o&&(e[i]?t(e[i],n[i]):e[i]=t(null,n[i])):e[i]=n[i]}))):e=n,e}(t,e)}function z(t){return H(null,t)}function R(t){return!t||0===Object.keys(t).length&&t.constructor===Object}function N(t,e){Object.keys(t).forEach((function(o){e(t[o],o)}))}function U(t){return null==t}function F(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];for(var n=0,i=e;n<i.length;n++){var r=i[n];if(!U(r))return r}}function W(t){this.message=t,"captureStackTrace"in Error?Error.captureStackTrace(this,W):this.stack=(new Error).stack}function V(t,e){if(t)for(var o=0,n=[["_",t]].concat(Object.entries(t));o<n.length;o++){var i=n[o][1];if(i.prototype instanceof e)return i}return null}function Z(){var t=new Error("Loading was aborted.");return t.name="AbortError",t}function j(t){return"AbortError"===(null==t?void 0:t.name)}function Y(t){console.warn("PhotoSphereViewer: "+t)}function X(t){return[["x","y"],["longitude","latitude"]].some((function(e){var o=e[0],n=e[1];return void 0!==t[o]&&void 0!==t[n]}))}function B(t,e){var o=t.match("<GPano:"+e+">(.*)</GPano:"+e+">");if(null!==o){var n=parseInt(o[1],10);return isNaN(n)?null:n}if(null!==(o=t.match("GPano:"+e+'="(.*?)"'))){var i=parseInt(o[1],10);return isNaN(i)?null:i}return null}W.prototype=Object.create(Error.prototype),W.prototype.name="PSVError",W.prototype.constructor=W;var G={top:"0%",bottom:"100%",left:"0%",right:"100%",center:"50%"};function q(t){if(!t)return{x:.5,y:.5};if("object"==typeof t)return t;var e=t.toLocaleLowerCase().split(" ").slice(0,2);1===e.length&&(e=void 0!==G[e[0]]?[e[0],"center"]:[e[0],e[0]]);var o="left"!==e[1]&&"right"!==e[1]&&"top"!==e[0]&&"bottom"!==e[0];e=e.map((function(t){return G[t]||t})),o||e.reverse();var n=e.join(" ").match(/^([0-9.]+)% ([0-9.]+)%$/);return n?{x:parseFloat(n[1])/100,y:parseFloat(n[2])/100}:{x:.5,y:.5}}var K={0:"left",.5:"center",1:"right"},Q={0:"top",.5:"center",1:"bottom"};function $(t,e,o){if(void 0===o&&(o=!0),!t)return e.split(" ");if("string"==typeof t){var n=q(t);if(!(n.x in K)||!(n.y in Q))throw new W('Unable to parse position "'+t+'"');t=[Q[n.y],K[n.x]]}if(!o&&"center"===t[0]&&"center"===t[1])throw new W('Unable to parse position "center center"');return t}function J(t){var o;if("string"==typeof t){var n=t.toString().trim(),i=parseFloat(n.replace(/^(-?[0-9]+(?:\.[0-9]*)?).*$/,"$1")),r=n.replace(/^-?[0-9]+(?:\.[0-9]*)?(.*)$/,"$1").trim();switch(r.match(/(pm|per minute)$/)&&(i/=60),r){case"dpm":case"degrees per minute":case"dps":case"degrees per second":o=e.Math.degToRad(i);break;case"rdpm":case"radians per minute":case"rdps":case"radians per second":o=i;break;case"rpm":case"revolutions per minute":case"rps":case"revolutions per second":o=i*Math.PI*2;break;default:throw new W('Unknown speed unit "'+r+'"')}}else o=t;return o}function tt(t,o,n){var i;if(void 0===o&&(o=!1),void 0===n&&(n=o),"string"==typeof t){var r=t.toLowerCase().trim().match(/^(-?[0-9]+(?:\.[0-9]*)?)(.*)$/);if(!r)throw new W('Unknown angle "'+t+'"');var s=parseFloat(r[1]),a=r[2];if(a)switch(a){case"deg":case"degs":i=e.Math.degToRad(s);break;case"rad":case"rads":i=s;break;default:throw new W('Unknown angle unit "'+a+'"')}else i=s}else{if("number"!=typeof t||isNaN(t))throw new W('Unknown angle "'+t+'"');i=t}return(i=(o?i+Math.PI:i)%(2*Math.PI))<0&&(i+=2*Math.PI),o?x(i-Math.PI,-Math.PI/(n?2:1),Math.PI/(n?2:1)):i}function et(t){var o=new e.Texture(t);return o.needsUpdate=!0,o.minFilter=e.LinearFilter,o.generateMipmaps=!1,o}var ot=new e.Quaternion;function nt(t,e){ot.setFromEuler(e).invert(),t.applyQuaternion(ot)}var it=Object.freeze({__proto__:null,toggleClass:f,addClasses:m,removeClasses:function(t,e){e&&e.split(" ").forEach((function(e){f(t,e,!1)}))},hasParent:function(t,e){var o=t;do{if(o===e)return!0;o=o.parentNode}while(o);return!1},getClosest:g,getPosition:w,getEventKey:E,isFullscreenEnabled:b,requestFullscreen:T,exitFullscreen:M,getStyle:O,normalizeWheel:L,bound:x,isInteger:function(t){return Number.isInteger?Number.isInteger(t):"number"==typeof t&&Number.isFinite(t)&&Math.floor(t)===t},isPowerOfTwo:C,sum:function(t){return t.reduce((function(t,e){return t+e}),0)},distance:A,getShortestArc:P,getAngle:S,greatArcDistance:function(t,e){var o=t[0],n=t[1],i=e[0],r=e[1],s=(i-o)*Math.cos((n+r)/2),a=r-n;return Math.sqrt(s*s+a*a)},dasherize:k,throttle:D,isPlainObject:I,deepmerge:H,clone:z,isEmpty:R,each:N,isNil:U,firstNonNull:F,pluginInterop:V,getAbortError:Z,isAbortError:j,logWarn:Y,isExtendedPosition:X,getXMPValue:B,parsePosition:q,cleanPosition:$,parseSpeed:J,parseAngle:tt,createTexture:et,applyEulerInverse:nt}),rt=function(){function t(t){var e=this;this.__callbacks=[],t?(t.easing&&"string"!=typeof t.easing||(t.easing=u[t.easing||"linear"]),this.__start=null,this.options=t,t.delay?this.__delayTimeout=setTimeout((function(){e.__delayTimeout=null,e.__animationFrame=window.requestAnimationFrame((function(t){return e.__run(t)}))}),t.delay):this.__animationFrame=window.requestAnimationFrame((function(t){return e.__run(t)}))):this.__resolved=!0}var e=t.prototype;return e.__run=function(t){var e=this;null===this.__start&&(this.__start=t);var o=(t-this.__start)/this.options.duration,n={};o<1?(N(this.options.properties,(function(t,i){t&&(n[i]=t.start+(t.end-t.start)*e.options.easing(o))})),this.options.onTick(n,o),this.__animationFrame=window.requestAnimationFrame((function(t){return e.__run(t)}))):(N(this.options.properties,(function(t,e){t&&(n[e]=t.end)})),this.options.onTick(n,1),this.__animationFrame=window.requestAnimationFrame((function(){e.__resolved=!0,e.__resolve(!0)})))},e.__resolve=function(t){this.__callbacks.forEach((function(e){return e(t)})),this.__callbacks.length=0},e.then=function(t,e){var o=this;return void 0===t&&(t=null),void 0===e&&(e=null),e&&Y("Animation#then does not accept a rejection handler anymore"),this.__resolved||this.__cancelled?Promise.resolve(this.__resolved).then(t):new Promise((function(t){o.__callbacks.push(t)})).then(t)},e.cancel=function(){this.__cancelled||this.__resolved||(this.__cancelled=!0,this.__resolve(!1),this.__delayTimeout&&(window.clearTimeout(this.__delayTimeout),this.__delayTimeout=null),this.__animationFrame&&(window.cancelAnimationFrame(this.__animationFrame),this.__animationFrame=null))},e.catch=function(){return Y("Animation#catch is not supported anymore"),this.then()},e.finally=function(t){return Y("Animation#finally is not supported anymore"),this.then(t)},t.resolve=function(){Y("Animation.resolve is not supported anymore")},t}();function st(t,e){for(var o=0;o<e.length;o++){var n=e[o];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}function at(){return at=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var o=arguments[e];for(var n in o)Object.prototype.hasOwnProperty.call(o,n)&&(t[n]=o[n])}return t},at.apply(this,arguments)}function ct(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t,ht(t,e)}function ht(t,e){return ht=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t},ht(t,e)}function lt(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}var pt=function(){function t(t,e){this.psv=t.psv||t,this.parent=t,this.parent.children.push(this),this.children=[],this.prop={visible:!0},this.container=document.createElement("div"),this.container.className=e,this.parent.container.appendChild(this.container)}var e=t.prototype;return e.destroy=function(){this.parent.container.removeChild(this.container);var t=this.parent.children.indexOf(this);-1!==t&&this.parent.children.splice(t,1),this.children.slice().forEach((function(t){return t.destroy()})),this.children.length=0,delete this.container,delete this.parent,delete this.psv,delete this.prop},e.refreshUi=function(){var t=this;this.children.every((function(e){return e.refreshUi(),!0===t.psv.prop.uiRefresh}))},e.toggle=function(){this.isVisible()?this.hide():this.show()},e.hide=function(){this.container.style.display="none",this.prop.visible=!1},e.show=function(){this.container.style.display="",this.prop.visible=!0},e.isVisible=function(){return this.prop.visible},t}(),ut=function(t){function e(e,o,n,i){var r;return void 0===o&&(o=""),void 0===n&&(n=!1),void 0===i&&(i=!0),(r=t.call(this,e,"psv-button "+o)||this).prop=at({},r.prop,{id:r.constructor.id,collapsable:n,enabled:!0,supported:!0,collapsed:!1,active:!1,width:r.container.offsetWidth}),r.constructor.icon&&r.__setIcon(r.constructor.icon),r.prop.id&&r.psv.config.lang[r.prop.id]&&(r.container.title=r.psv.config.lang[r.prop.id]),i&&(r.container.tabIndex=0),r.container.addEventListener("click",(function(t){r.prop.enabled&&r.onClick(),t.stopPropagation()})),r.container.addEventListener("keydown",(function(t){E(t)===d.Enter&&r.prop.enabled&&(r.onClick(),t.stopPropagation())})),r}ct(e,t);var o=e.prototype;return o.checkSupported=function(){var t=this,e=this.isSupported();I(e)?(!1===e.initial&&(this.hide(),this.prop.supported=!1),e.promise.then((function(e){t.prop&&(t.prop.supported=e,!e&&t.prop.visible?t.hide():e&&!t.prop.visible&&t.show())}))):e||(this.hide(),this.prop.supported=!1)},o.isSupported=function(){return!0},o.toggleActive=function(t){this.prop.active=void 0!==t?t:!this.prop.active,f(this.container,"psv-button--active",this.prop.active),this.constructor.iconActive&&this.__setIcon(this.prop.active?this.constructor.iconActive:this.constructor.icon)},o.show=function(t){void 0===t&&(t=!0),this.isVisible()||(this.prop.visible=!0,this.prop.collapsed||(this.container.style.display=""),t&&this.psv.refreshUi("show button "+this.prop.id))},o.hide=function(t){void 0===t&&(t=!0),this.isVisible()&&(this.prop.visible=!1,this.container.style.display="none",t&&this.psv.refreshUi("hide button "+this.prop.id))},o.disable=function(){this.container.classList.add("psv-button--disabled"),this.prop.enabled=!1},o.enable=function(){this.container.classList.remove("psv-button--disabled"),this.prop.enabled=!0},o.collapse=function(){this.prop.collapsed=!0,this.container.style.display="none"},o.uncollapse=function(){this.prop.collapsed=!1,this.prop.visible&&(this.container.style.display="")},o.__setIcon=function(t,e){void 0===e&&(e=this.container),t?(e.innerHTML=t,e.querySelector("svg").setAttribute("class","psv-button-svg")):e.innerHTML=""},o.onClick=function(){throw new W('onClick not implemented for button "'+this.prop.id+'".')},e}(pt);ut.id=null,ut.icon=null,ut.iconActive=null;var dt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-button--hover-scale psv-autorotate-button",!0)||this).psv.on(c.AUTOROTATE,lt(o)),o}ct(e,t);var o=e.prototype;return o.destroy=function(){this.psv.off(c.AUTOROTATE,this),t.prototype.destroy.call(this)},o.handleEvent=function(t){if(t.type===c.AUTOROTATE)this.toggleActive(t.args[0])},o.onClick=function(){this.psv.toggleAutorotate()},e}(ut);dt.id="autorotate",dt.icon='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 41 41"><path fill="currentColor" d="M40.5 14.1c-.1-.1-1.2-.5-2.899-1-.101 0-.2-.1-.2-.2C34.5 6.5 28 2 20.5 2S6.6 6.5 3.7 12.9c0 .1-.1.1-.2.2-1.7.6-2.8 1-2.9 1l-.6.3v12.1l.6.2c.1 0 1.1.4 2.7.9.1 0 .2.1.2.199C6.3 34.4 12.9 39 20.5 39c7.601 0 14.101-4.6 16.9-11.1 0-.101.1-.101.2-.2 1.699-.6 2.699-1 2.8-1l.6-.3V14.3l-.5-.2zM20.5 4c5.8 0 10.9 3 13.8 7.5.2.3-.1.6-.399.5-3.8-1-8.8-2-13.6-2-4.7 0-9.5 1-13.2 2-.3.1-.5-.2-.4-.5C9.7 7 14.8 4 20.5 4zm0 33c-5.9 0-11.1-3.1-14-7.899-.2-.301.1-.601.4-.5 3.9 1 8.9 2.1 13.6 2.1 5 0 9.9-1 13.601-2 .3-.1.5.2.399.5A16.422 16.422 0 0 1 20.5 37zm18.601-12.1c0 .1-.101.3-.2.3-2.5.9-10.4 3.6-18.4 3.6-7.1 0-15.6-2.699-18.3-3.6C2.1 25.2 2 25 2 24.9V16c0-.1.1-.3.2-.3 2.6-.9 10.6-3.6 18.2-3.6 7.5 0 15.899 2.7 18.5 3.6.1 0 .2.2.2.3v8.9z"/><path fill="currentColor" d="M18.7 24l6.4-3.7c.3-.2.3-.7 0-.8l-6.4-3.8c-.3-.2-.7 0-.7.4v7.4c0 .5.4.7.7.5z"/>\x3c!--Created by Nick Bluth from the Noun Project--\x3e</svg>\n',dt.iconActive='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 41 41"><path fill="currentColor" d="M40.5 14.1c-.1-.1-1.2-.5-2.898-1-.102 0-.202-.1-.202-.2C34.5 6.5 28 2 20.5 2S6.6 6.5 3.7 12.9c0 .1-.1.1-.2.2-1.7.6-2.8 1-2.9 1l-.6.3v12.1l.6.2c.1 0 1.1.399 2.7.899.1 0 .2.101.2.199C6.3 34.4 12.9 39 20.5 39c7.602 0 14.102-4.6 16.9-11.1 0-.102.1-.102.199-.2 1.699-.601 2.699-1 2.801-1l.6-.3V14.3l-.5-.2zM6.701 11.5C9.7 7 14.8 4 20.5 4c5.8 0 10.9 3 13.8 7.5.2.3-.1.6-.399.5-3.799-1-8.799-2-13.6-2-4.7 0-9.5 1-13.2 2-.3.1-.5-.2-.4-.5zM25.1 20.3L18.7 24c-.3.2-.7 0-.7-.5v-7.4c0-.4.4-.6.7-.4l6.399 3.8c.301.1.301.6.001.8zm9.4 8.901A16.421 16.421 0 0 1 20.5 37c-5.9 0-11.1-3.1-14-7.898-.2-.302.1-.602.4-.5 3.9 1 8.9 2.1 13.6 2.1 5 0 9.9-1 13.602-2 .298-.1.5.198.398.499z"/>\x3c!--Created by Nick Bluth from the Noun Project--\x3e</svg>\n';var vt=function(t){function e(e,o){var n;return(n=t.call(this,e,"psv-custom-button",!1!==o.collapsable,!1!==o.tabbable)||this).config=o,n.config.id?n.prop.id=n.config.id:n.prop.id="psvButton-"+Math.random().toString(36).substr(2,9),n.config.className&&m(n.container,n.config.className),n.config.title&&(n.container.title=n.config.title),n.config.content&&(n.container.innerHTML=n.config.content),n.prop.width=n.container.offsetWidth,!1===n.config.enabled&&n.disable(),!1===n.config.visible&&n.hide(),n}ct(e,t);var o=e.prototype;return o.destroy=function(){delete this.config,t.prototype.destroy.call(this)},o.onClick=function(){this.config.onClick&&this.config.onClick.apply(this.psv)},e}(ut),ft=function(t){function e(e){return t.call(this,e,"psv-button--hover-scale psv-download-button",!0)||this}ct(e,t);var o=e.prototype;return o.isSupported=function(){return this.psv.adapter.constructor.supportsDownload||!!this.psv.config.downloadUrl},o.onClick=function(){var t=this,e=document.createElement("a");e.href=this.psv.config.downloadUrl||this.psv.config.panorama,e.download=e.href.split("/").pop(),this.psv.container.appendChild(e),e.click(),setTimeout((function(){t.psv.container.removeChild(e)}),100)},e}(ut);ft.id="download",ft.icon='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M83.3 35.6h-17V3H32.2v32.6H16.6l33.6 32.7 33-32.7z"/><path fill="currentColor" d="M83.3 64.2v16.3H16.6V64.2H-.1v32.6H100V64.2H83.3z"/>\x3c!--Created by Michael Zenaty from the Noun Project--\x3e</svg>\n';var mt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-button--hover-scale psv-fullscreen-button")||this).psv.on(c.FULLSCREEN_UPDATED,lt(o)),o}ct(e,t);var o=e.prototype;return o.destroy=function(){this.psv.off(c.FULLSCREEN_UPDATED,this),t.prototype.destroy.call(this)},o.handleEvent=function(t){if(t.type===c.FULLSCREEN_UPDATED)this.toggleActive(t.args[0])},o.onClick=function(){this.psv.toggleFullscreen()},e}(ut);mt.id="fullscreen",mt.icon='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M100 40H87.1V18.8h-21V6H100zM100 93.2H66V80.3h21.1v-21H100zM34 93.2H0v-34h12.9v21.1h21zM12.9 40H0V6h34v12.9H12.8z"/>\x3c!--Created by Garrett Knoll from the Noun Project--\x3e</svg>\n',mt.iconActive='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M66 7h13v21h21v13H66zM66 60.3h34v12.9H79v21H66zM0 60.3h34v34H21V73.1H0zM21 7h13v34H0V28h21z"/>\x3c!--Created by Garrett Knoll from the Noun Project--\x3e</svg>\n';var gt='<svg xmlns="http://www.w3.org/2000/svg" viewBox="10 10 80 80"><g fill="currentColor"><circle r="10" cx="20" cy="20"/><circle r="10" cx="50" cy="20"/><circle r="10" cx="80" cy="20"/><circle r="10" cx="20" cy="50"/><circle r="10" cx="50" cy="50"/><circle r="10" cx="80" cy="50"/><circle r="10" cx="20" cy="80"/><circle r="10" cx="50" cy="80"/><circle r="10" cx="80" cy="80"/></g>\x3c!-- Created by Richard Kunák from the Noun Project--\x3e</svg>\n',wt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-button--hover-scale psv-menu-button")||this).psv.on(c.OPEN_PANEL,lt(o)),o.psv.on(c.CLOSE_PANEL,lt(o)),o.hide(),o}ct(e,t);var o=e.prototype;return o.destroy=function(){this.psv.off(c.OPEN_PANEL,this),this.psv.off(c.CLOSE_PANEL,this),t.prototype.destroy.call(this)},o.handleEvent=function(t){switch(t.type){case c.OPEN_PANEL:this.toggleActive(t.args[0]===p.MENU);break;case c.CLOSE_PANEL:this.toggleActive(!1)}},o.hide=function(e){t.prototype.hide.call(this,e),this.__hideMenu()},o.show=function(e){t.prototype.show.call(this,e),this.prop.active&&this.__showMenu()},o.onClick=function(){this.prop.active?this.__hideMenu():this.__showMenu()},o.__showMenu=function(){var t=this;this.psv.panel.show({id:p.MENU,content:e.MENU_TEMPLATE(this.parent.collapsed,this.psv,k(e.BUTTON_DATA)),noMargin:!0,clickHandler:function(o){var n=o.target?g(o.target,"li"):void 0,i=n?n.dataset[e.BUTTON_DATA]:void 0;i&&(t.parent.getButton(i).onClick(),t.__hideMenu())}})},o.__hideMenu=function(){this.psv.panel&&this.psv.panel.hide(p.MENU)},e}(ut);wt.id="menu",wt.icon=gt,wt.BUTTON_DATA="psvButton",wt.MENU_TEMPLATE=function(t,e,o){return'\n<div class="psv-panel-menu psv-panel-menu--stripped">\n  <h1 class="psv-panel-menu-title">'+gt+" "+e.config.lang.menu+'</h1>\n  <ul class="psv-panel-menu-list">\n    '+t.map((function(t){return"\n    <li data-"+o+'="'+t.prop.id+'" class="psv-panel-menu-item" tabindex="0">\n      <span class="psv-panel-menu-item-icon">'+t.container.innerHTML+'</span>\n      <span class="psv-panel-menu-item-label">'+t.container.title+"</span>\n    </li>\n    "})).join("")+"\n  </ul>\n</div>\n"};var _t={loaded:!1,pixelRatio:1,isWebGLSupported:!1,isTouchEnabled:null,maxTextureWidth:0,mouseWheelEvent:null,fullscreenEvent:null};_t.load=function(){if(!_t.loaded){var t=function(){var t=document.createElement("canvas"),e=["webgl","experimental-webgl","moz-webgl","webkit-3d"],o=null;if(!t.getContext)return null;return e.some((function(e){try{return null!==(o=t.getContext(e))}catch(t){return!1}}))?o:null}();_t.loaded=!0,_t.pixelRatio=window.devicePixelRatio||1,_t.isWebGLSupported=null!=t,_t.isTouchEnabled=new Promise((function(t){var e=function e(o){t(!!o),window.removeEventListener("touchstart",e)};window.addEventListener("touchstart",e,!1),setTimeout(e,1e4)})),_t.maxTextureWidth=function(t){return null!==t?t.getParameter(t.MAX_TEXTURE_SIZE):0}(t),_t.mouseWheelEvent="onwheel"in document.createElement("div")?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll",_t.fullscreenEvent=(e=Object.keys(Et).filter((function(t){return t in document}))).length?Et[e[0]]:null}var e};var yt=null;_t.getMaxCanvasWidth=function(){return null===yt&&(yt=function(t){var e=document.createElement("canvas"),o=e.getContext("2d");e.width=t,e.height=t/2;for(;e.width>1024;){o.fillStyle="white",o.fillRect(0,0,1,1);try{if(255===o.getImageData(0,0,1,1).data[0])return e.width}catch(t){}e.width/=2,e.height/=2}throw new W("Unable to detect system capabilities")}(_t.maxTextureWidth)),yt};var Et={exitFullscreen:"fullscreenchange",webkitExitFullscreen:"webkitfullscreenchange",mozCancelFullScreen:"mozfullscreenchange",msExitFullscreen:"MSFullscreenChange"};var bt=function(){function t(t){void 0===t&&(t=200),this.delay=t,this.time=0,this.timeout=null}var e=t.prototype;return e.down=function(){this.timeout&&(clearTimeout(this.timeout),this.timeout=null),this.time=(new Date).getTime()},e.up=function(t){var e=this;this.time&&((new Date).getTime()-this.time<this.delay?this.timeout=setTimeout((function(){t(),e.timeout=null,e.time=0}),this.delay):(t(),this.time=0))},t}();function Tt(t){var e=0;switch(t){case"up":e=90;break;case"right":e=180;break;case"down":e=-90;break;default:e=0}return'<svg xmlns="http://www.w3.org/2000/svg" viewBox="40 40 432 432"><g transform="rotate(0, 256, 256)"><path fill="currentColor" d="M425.23 210.55H227.39a5 5 0 01-3.53-8.53l56.56-56.57a45.5 45.5 0 000-64.28 45.15 45.15 0 00-32.13-13.3 45.15 45.15 0 00-32.14 13.3L41.32 256l174.83 174.83a45.15 45.15 0 0032.14 13.3 45.15 45.15 0 0032.13-13.3 45.5 45.5 0 000-64.28l-56.57-56.57a5 5 0 013.54-8.53h197.84c25.06 0 45.45-20.39 45.45-45.45s-20.4-45.45-45.45-45.45z"/></g>\x3c!-- Created by Flatart from the Noun Project --\x3e</svg>\n'.replace("rotate(0","rotate("+e)}var Mt=function(t){function e(e,o){var n;return(n=t.call(this,e,"psv-button--hover-scale psv-move-button")||this).container.title=n.psv.config.lang.move,n.prop=at({},n.prop,{value:o,handler:new bt}),n.container.addEventListener("mousedown",lt(n)),n.container.addEventListener("keydown",lt(n)),n.container.addEventListener("keyup",lt(n)),n.psv.container.addEventListener("mouseup",lt(n)),n.psv.container.addEventListener("touchend",lt(n)),n}ct(e,t);var o=e.prototype;return o.destroy=function(){this.__onMouseUp(),this.psv.container.removeEventListener("mouseup",this),this.psv.container.removeEventListener("touchend",this),t.prototype.destroy.call(this)},o.handleEvent=function(t){switch(t.type){case"mousedown":this.__onMouseDown();break;case"mouseup":case"touchend":this.__onMouseUp();break;case"keydown":E(t)===d.Enter&&this.__onMouseDown();break;case"keyup":E(t)===d.Enter&&this.__onMouseUp()}},o.isSupported=function(){return{initial:!0,promise:_t.isTouchEnabled.then((function(t){return!t}))}},o.onClick=function(){},o.__onMouseDown=function(){this.prop.enabled&&(this.psv.__stopAll(),this.psv.dynamics.position.roll(this.prop.value),this.prop.handler.down())},o.__onMouseUp=function(){var t=this;this.prop.enabled&&this.prop.handler.up((function(){return t.psv.dynamics.position.stop()}))},e}(ut),Ot=function(t){function e(e){return t.call(this,e,{latitude:!0})||this}return ct(e,t),e}(Mt);Ot.id="moveDown",Ot.icon=Tt("down");var Lt=function(t){function e(e){return t.call(this,e,{longitude:!0})||this}return ct(e,t),e}(Mt);Lt.id="moveLeft",Lt.icon=Tt("left");var xt=function(t){function e(e){return t.call(this,e,{longitude:!1})||this}return ct(e,t),e}(Mt);xt.id="moveRight",xt.icon=Tt("right");var Ct=function(t){function e(e){return t.call(this,e,{latitude:!1})||this}return ct(e,t),e}(Mt);Ct.id="moveUp",Ct.icon=Tt("up");var At=function(t){function e(e,o){var n;return(n=t.call(this,e,"psv-button--hover-scale psv-zoom-button")||this).prop=at({},n.prop,{value:o,handler:new bt}),n.container.addEventListener("mousedown",lt(n)),n.container.addEventListener("keydown",lt(n)),n.container.addEventListener("keyup",lt(n)),n.psv.container.addEventListener("mouseup",lt(n)),n.psv.container.addEventListener("touchend",lt(n)),n}ct(e,t);var o=e.prototype;return o.destroy=function(){this.__onMouseUp(),this.psv.container.removeEventListener("mouseup",this),this.psv.container.removeEventListener("touchend",this),t.prototype.destroy.call(this)},o.handleEvent=function(t){switch(t.type){case"mousedown":this.__onMouseDown();break;case"mouseup":case"touchend":this.__onMouseUp();break;case"keydown":E(t)===d.Enter&&this.__onMouseDown();break;case"keyup":E(t)===d.Enter&&this.__onMouseUp()}},o.isSupported=function(){return{initial:!0,promise:_t.isTouchEnabled.then((function(t){return!t}))}},o.onClick=function(){},o.__onMouseDown=function(){this.prop.enabled&&(this.psv.dynamics.zoom.roll(this.prop.value),this.prop.handler.down())},o.__onMouseUp=function(){var t=this;this.prop.enabled&&this.prop.handler.up((function(){return t.psv.dynamics.zoom.stop()}))},e}(ut),Pt=function(t){function e(e){return t.call(this,e,!1)||this}return ct(e,t),e}(At);Pt.id="zoomIn",Pt.icon='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="currentColor" d="M14.043 12.22a7.738 7.738 0 1 0-1.823 1.822l4.985 4.985c.503.504 1.32.504 1.822 0a1.285 1.285 0 0 0 0-1.822l-4.984-4.985zm-6.305 1.043a5.527 5.527 0 1 1 0-11.053 5.527 5.527 0 0 1 0 11.053z"/><path fill="currentColor" d="M8.728 4.009H6.744v2.737H4.006V8.73h2.738v2.736h1.984V8.73h2.737V6.746H8.728z"/>\x3c!--Created by Ryan Canning from the Noun Project--\x3e</svg>\n';var St=function(t){function e(e){return t.call(this,e,!0)||this}return ct(e,t),e}(At);St.id="zoomOut",St.icon='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="currentColor" d="M14.043 12.22a7.738 7.738 0 1 0-1.823 1.822l4.985 4.985c.503.504 1.32.504 1.822 0a1.285 1.285 0 0 0 0-1.822l-4.984-4.985zm-6.305 1.043a5.527 5.527 0 1 1 0-11.053 5.527 5.527 0 0 1 0 11.053z"/><path fill="currentColor" d="M4.006 6.746h7.459V8.73H4.006z"/>\x3c!--Created by Ryan Canning from the Noun Project--\x3e</svg>\n';var kt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-zoom-range",!1,!1)||this).prop=at({},o.prop,{mousedown:!1,mediaMinWidth:0}),o.zoomRange=document.createElement("div"),o.zoomRange.className="psv-zoom-range-line",o.container.appendChild(o.zoomRange),o.zoomValue=document.createElement("div"),o.zoomValue.className="psv-zoom-range-handle",o.zoomRange.appendChild(o.zoomValue),o.prop.mediaMinWidth=parseInt(O(o.container,"maxWidth"),10),o.container.addEventListener("mousedown",lt(o)),o.container.addEventListener("touchstart",lt(o)),o.psv.container.addEventListener("mousemove",lt(o)),o.psv.container.addEventListener("touchmove",lt(o)),o.psv.container.addEventListener("mouseup",lt(o)),o.psv.container.addEventListener("touchend",lt(o)),o.psv.on(c.ZOOM_UPDATED,lt(o)),o.psv.prop.ready?o.__moveZoomValue(o.psv.getZoomLevel()):o.psv.once(c.READY,lt(o)),o.refreshUi(),o}ct(e,t);var o=e.prototype;return o.destroy=function(){this.__stopZoomChange(),this.psv.container.removeEventListener("mousemove",this),this.psv.container.removeEventListener("touchmove",this),this.psv.container.removeEventListener("mouseup",this),this.psv.container.removeEventListener("touchend",this),delete this.zoomRange,delete this.zoomValue,this.psv.off(c.ZOOM_UPDATED,this),t.prototype.destroy.call(this)},o.handleEvent=function(t){switch(t.type){case"mousedown":this.__initZoomChangeWithMouse(t);break;case"touchstart":this.__initZoomChangeByTouch(t);break;case"mousemove":this.__changeZoomWithMouse(t);break;case"touchmove":this.__changeZoomByTouch(t);break;case"mouseup":case"touchend":this.__stopZoomChange(t);break;case c.ZOOM_UPDATED:this.__moveZoomValue(t.args[0]);break;case c.READY:this.__moveZoomValue(this.psv.getZoomLevel())}},o.isSupported=function(){return{initial:!0,promise:_t.isTouchEnabled.then((function(t){return!t}))}},o.refreshUi=function(){this.prop.supported&&(this.psv.prop.size.width<=this.prop.mediaMinWidth&&this.prop.visible?this.hide():this.psv.prop.size.width>this.prop.mediaMinWidth&&!this.prop.visible&&this.show())},o.onClick=function(){},o.__moveZoomValue=function(t){this.zoomValue.style.left=t/100*this.zoomRange.offsetWidth-this.zoomValue.offsetWidth/2+"px"},o.__initZoomChangeWithMouse=function(t){this.prop.enabled&&(this.prop.mousedown=!0,this.__changeZoom(t.clientX))},o.__initZoomChangeByTouch=function(t){this.prop.enabled&&(this.prop.mousedown=!0,this.__changeZoom(t.changedTouches[0].clientX))},o.__stopZoomChange=function(){this.prop.enabled&&(this.prop.mousedown=!1,this.prop.buttondown=!1)},o.__changeZoomWithMouse=function(t){this.prop.enabled&&this.prop.mousedown&&(t.preventDefault(),this.__changeZoom(t.clientX))},o.__changeZoomByTouch=function(t){this.prop.enabled&&this.prop.mousedown&&this.__changeZoom(t.changedTouches[0].clientX)},o.__changeZoom=function(t){var e=(t-this.zoomRange.getBoundingClientRect().left)/this.zoomRange.offsetWidth*100;this.psv.zoom(e)},e}(ut);kt.id="zoomRange";var Dt=function(){function t(t){this.psv=t}var e=t.prototype;return e.destroy=function(){delete this.psv},e.supportsTransition=function(t){return!1},e.supportsPreload=function(t){return!1},e.loadTexture=function(t,e){throw new W("loadTexture not implemented")},e.createMesh=function(t){throw new W("createMesh not implemented")},e.setTexture=function(t,e,o){throw new W("setTexture not implemented")},e.setTextureOpacity=function(t,e){throw new W("setTextureOpacity not implemented")},e.disposeTexture=function(t){throw new W("disposeTexture not implemented")},t}();Dt.id=null,Dt.supportsDownload=!1;var It=function(t){function o(e,o){var n;if((n=t.call(this,e)||this).config=at({resolution:64},o),!C(n.config.resolution))throw new W("EquirectangularAdapter resolution must be power of two");return n.SPHERE_SEGMENTS=n.config.resolution,n.SPHERE_HORIZONTAL_SEGMENTS=n.SPHERE_SEGMENTS/2,n}ct(o,t);var n=o.prototype;return n.supportsTransition=function(){return!0},n.supportsPreload=function(){return!0},n.loadTexture=function(t,e){var o=this;return"string"!=typeof t?((Array.isArray(t)||"object"==typeof t&&t.left)&&Y("Cubemap support now requires an additional adapter, see https://photo-sphere-viewer.js.org/guide/adapters"),Promise.reject(new W("Invalid panorama url, are you using the right adapter?"))):(this.psv.config.useXmpData?this.__loadXMP(t,(function(t){return o.psv.loader.setProgress(t)})).then((function(e){return o.psv.textureLoader.loadImage(t).then((function(t){return{img:t,xmpPanoData:e}}))})):this.psv.textureLoader.loadImage(t,(function(t){return o.psv.loader.setProgress(t)})).then((function(t){return{img:t,xmpPanoData:null}}))).then((function(n){var i,r,s,a,c,h,l,p,u,d=n.img,v=n.xmpPanoData;"function"==typeof e&&(e=e(d));var f={fullWidth:F(null==(i=e)?void 0:i.fullWidth,null==v?void 0:v.fullWidth,d.width),fullHeight:F(null==(r=e)?void 0:r.fullHeight,null==v?void 0:v.fullHeight,d.height),croppedWidth:F(null==(s=e)?void 0:s.croppedWidth,null==v?void 0:v.croppedWidth,d.width),croppedHeight:F(null==(a=e)?void 0:a.croppedHeight,null==v?void 0:v.croppedHeight,d.height),croppedX:F(null==(c=e)?void 0:c.croppedX,null==v?void 0:v.croppedX,0),croppedY:F(null==(h=e)?void 0:h.croppedY,null==v?void 0:v.croppedY,0),poseHeading:F(null==(l=e)?void 0:l.poseHeading,null==v?void 0:v.poseHeading,0),posePitch:F(null==(p=e)?void 0:p.posePitch,null==v?void 0:v.posePitch,0),poseRoll:F(null==(u=e)?void 0:u.poseRoll,null==v?void 0:v.poseRoll,0)};f.croppedWidth===d.width&&f.croppedHeight===d.height||Y("Invalid panoData, croppedWidth and/or croppedHeight is not coherent with loaded image.\n    panoData: "+f.croppedWidth+"x"+f.croppedHeight+", image: "+d.width+"x"+d.height),(e||v)&&f.fullWidth!==2*f.fullHeight&&Y("Invalid panoData, fullWidth should be twice fullHeight");var m=o.__createEquirectangularTexture(d,f);return{panorama:t,texture:m,panoData:f}}))},n.__loadXMP=function(t,e){var o=this;return this.psv.textureLoader.loadFile(t,e).then((function(t){return o.__loadBlobAsString(t)})).then((function(t){var e=t.indexOf("<x:xmpmeta"),o=t.indexOf("</x:xmpmeta>"),n=t.substring(e,o);return-1!==e&&-1!==o&&-1!==n.indexOf("GPano:")?{fullWidth:B(n,"FullPanoWidthPixels"),fullHeight:B(n,"FullPanoHeightPixels"),croppedWidth:B(n,"CroppedAreaImageWidthPixels"),croppedHeight:B(n,"CroppedAreaImageHeightPixels"),croppedX:B(n,"CroppedAreaLeftPixels"),croppedY:B(n,"CroppedAreaTopPixels"),poseHeading:B(n,"PoseHeadingDegrees"),posePitch:B(n,"PosePitchDegrees"),poseRoll:B(n,"PoseRollDegrees")}:null}))},n.__loadBlobAsString=function(t){return new Promise((function(e,o){var n=new FileReader;n.onload=function(){return e(n.result)},n.onerror=o,n.readAsText(t)}))},n.__createEquirectangularTexture=function(t,e){if(e.fullWidth>_t.maxTextureWidth||e.croppedWidth!==e.fullWidth||e.croppedHeight!==e.fullHeight){var o=_t.getMaxCanvasWidth()/e.fullWidth,n=at({},e);o<1&&(n.fullWidth*=o,n.fullHeight*=o,n.croppedWidth*=o,n.croppedHeight*=o,n.croppedX*=o,n.croppedY*=o);var i=document.createElement("canvas");return i.width=n.fullWidth,i.height=n.fullHeight,i.getContext("2d").drawImage(t,n.croppedX,n.croppedY,n.croppedWidth,n.croppedHeight),et(i)}return et(t)},n.createMesh=function(t){void 0===t&&(t=1);var o=new e.SphereGeometry(i*t,this.SPHERE_SEGMENTS,this.SPHERE_HORIZONTAL_SEGMENTS,-Math.PI/2).scale(-1,1,1),n=new e.MeshBasicMaterial;return new e.Mesh(o,n)},n.setTexture=function(t,e){var o,n=e.texture;null==(o=t.material.map)||o.dispose(),t.material.map=n},n.setTextureOpacity=function(t,e){t.material.opacity=e,t.material.transparent=e<1},n.disposeTexture=function(t){var e;null==(e=t.texture)||e.dispose()},o}(Dt);It.id="equirectangular",It.supportsDownload=!0;var Ht,zt=function(t){function e(e){var o;return(o=t.call(this)||this).psv=e,o}ct(e,t);var o=e.prototype;return o.init=function(){},o.destroy=function(){delete this.psv},e}(o.EventEmitter);zt.id=null;var Rt={panorama:null,container:null,adapter:null,plugins:[],caption:null,downloadUrl:null,loadingImg:null,loadingTxt:"Loading...",size:null,fisheye:!1,minFov:30,maxFov:90,defaultZoomLvl:50,defaultLong:0,defaultLat:0,sphereCorrection:null,moveSpeed:1,zoomSpeed:1,autorotateDelay:null,autorotateSpeed:"2rpm",autorotateLat:null,moveInertia:!0,mousewheel:!0,mousemove:!0,captureCursor:!1,mousewheelCtrlKey:!1,touchmoveTwoFingers:!1,useXmpData:!0,panoData:null,requestHeaders:null,canvasBackground:"#000",withCredentials:!1,navbar:["autorotate","zoom","move","download","caption","fullscreen"],lang:{autorotate:"Automatic rotation",zoom:"Zoom",zoomOut:"Zoom out",zoomIn:"Zoom in",move:"Move",download:"Download",fullscreen:"Fullscreen",menu:"Menu",twoFingers:"Use two fingers to navigate",ctrlZoom:"Use ctrl + scroll to zoom the image",loadError:"The panorama can't be loaded"},keyboard:(Ht={},Ht[d.ArrowUp]=a.ROTATE_LAT_UP,Ht[d.ArrowDown]=a.ROTATE_LAT_DOWN,Ht[d.ArrowRight]=a.ROTATE_LONG_RIGHT,Ht[d.ArrowLeft]=a.ROTATE_LONG_LEFT,Ht[d.PageUp]=a.ZOOM_IN,Ht[d.PageDown]=a.ZOOM_OUT,Ht[d.Plus]=a.ZOOM_IN,Ht[d.Minus]=a.ZOOM_OUT,Ht[d.Space]=a.TOGGLE_AUTOROTATE,Ht)},Nt={panorama:"Use setPanorama method to change the panorama",panoData:"Use setPanorama method to change the panorama",container:"Cannot change viewer container",adapter:"Cannot change adapter",plugins:"Cannot change plugins"},Ut={zoomButtonIncrement:"zoomButtonIncrement is deprecated, use zoomSpeed",mousewheelSpeed:"mousewheelSpeed is deprecated, use zoomSpeed",sphereCorrectionReorder:"sphereCorrectionReorder is deprecated"},Ft={container:function(t){if(!t)throw new W("No value given for container.");return t},adapter:function(t){if(!(t=t?Array.isArray(t)?[V(t[0],Dt),t[1]]:[V(t,Dt)]:[It])[0])throw new W("Un undefined value with given for adapter.");return t},defaultLong:function(t){return tt(t)},defaultLat:function(t){return tt(t,!0)},minFov:function(t,e){return e.maxFov<t&&(Y("maxFov cannot be lower than minFov"),t=e.maxFov),x(t,1,179)},maxFov:function(t,e){return t<e.minFov&&(t=e.minFov),x(t,1,179)},lang:function(t){return Array.isArray(t.twoFingers)&&(Y("lang.twoFingers must not be an array"),t.twoFingers=t.twoFingers[0]),at({},Rt.lang,t)},keyboard:function(t){return!0===t?z(Rt.keyboard):t},autorotateLat:function(t,e){return tt(null===t?e.defaultLat:t,!0)},autorotateSpeed:function(t){return J(t)},fisheye:function(t){return!0===t?1:!1===t?0:t},plugins:function(t){return t.map((function(t){if(!(t=Array.isArray(t)?[V(t[0],zt),t[1]]:[V(t,zt)])[0])throw new W("Un undefined value was given for plugins.");return t}))}};var Wt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-button--hover-scale psv-caption-button")||this).psv.on(c.HIDE_NOTIFICATION,lt(o)),o}ct(e,t);var o=e.prototype;return o.destroy=function(){this.psv.off(c.HIDE_NOTIFICATION,this),t.prototype.destroy.call(this)},o.handleEvent=function(t){if(t.type===c.HIDE_NOTIFICATION)this.toggleActive(!1)},o.onClick=function(){this.psv.notification.prop.visible?this.psv.notification.hide():(this.psv.notification.show(this.parent.prop.caption),this.toggleActive(!0))},e}(ut);Wt.id="caption",Wt.icon='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><path fill="currentColor" d="M28.3 26.1c-1 2.6-1.9 4.8-2.6 7-2.5 7.4-5 14.7-7.2 22-1.3 4.4.5 7.2 4.3 7.8 1.3.2 2.8.2 4.2-.1 8.2-2 11.9-8.6 15.7-15.2l-2.2 2a18.8 18.8 0 0 1-7.4 5.2 2 2 0 0 1-1.6-.2c-.2-.1 0-1 0-1.4l.8-1.8L41.9 28c.5-1.4.9-3 .7-4.4-.2-2.6-3-4.4-6.3-4.4-8.8.2-15 4.5-19.5 11.8-.2.3-.2.6-.3 1.3 3.7-2.8 6.8-6.1 11.8-6.2z"/><circle fill="currentColor" cx="39.3" cy="9.2" r="8.2"/>\x3c!--Created by Arafat Uddin from the Noun Project--\x3e</svg>\n';var Vt=function(t){function e(e,o){var n;return(n=t.call(this,e,"psv-caption")||this).button=new Wt(lt(n)),n.button.hide(),n.prop=at({},n.prop,{id:n.constructor.id,collapsable:!1,width:n.button.prop.width,caption:"",contentVisible:!0,contentWidth:0}),n.content=document.createElement("div"),n.content.className="psv-caption-content",n.container.appendChild(n.content),n.setCaption(o),n}ct(e,t);var o=e.prototype;return o.destroy=function(){delete this.button,delete this.content,t.prototype.destroy.call(this)},o.setCaption=function(t){this.prop.caption=t||"",this.content.innerHTML=this.prop.caption,t?(this.show(!1),this.content.style.display="",this.prop.contentWidth=this.content.offsetWidth,this.refreshUi()):this.hide()},o.refreshUi=function(){var t=this.container.offsetWidth;t>=this.prop.contentWidth&&!this.prop.contentVisible?(this.content.style.display="",this.prop.contentVisible=!0,this.button.hide(!1)):t<this.prop.contentWidth&&this.prop.contentVisible&&(this.content.style.display="none",this.prop.contentVisible=!1,this.button.show(!1))},e}(pt);Vt.id="caption";var Zt={};function jt(t,e){if(!t.id)throw new W("Button ID is required");if(Zt[t.id]=t,"string"==typeof e)switch(e){case"start":Rt.navbar.unshift(t.id);break;case"end":Rt.navbar.push(t.id);break;default:var o=e.split(":"),n=o[0],i=o[1];Rt.navbar.splice(Rt.navbar.indexOf(n)+("right"===i?1:0),0,t.id)}}[dt,Pt,kt,St,ft,mt,xt,Lt,Ct,Ot].forEach(jt);var Yt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-navbar")||this).children=[],o.collapsed=[],o}ct(e,t);var o=e.prototype;return o.setButtons=function(t){var e=this;this.children.slice().forEach((function(t){return t.destroy()})),this.children.length=0,this.__cleanButtons(t).forEach((function(t){if("object"==typeof t)new vt(e,t);else if(Zt[t])new Zt[t](e);else if("caption"===t)new Vt(e,e.psv.config.caption);else if("zoom"===t)new St(e),new kt(e),new Pt(e);else{if("move"!==t)throw new W("Unknown button "+t);new Lt(e),new xt(e),new Ct(e),new Ot(e)}})),new wt(this),this.children.forEach((function(t){"function"==typeof t.checkSupported&&t.checkSupported()}))},o.setCaption=function(t){var e=this.getButton("caption",!1);null==e||e.setCaption(t)},o.getButton=function(t,e){void 0===e&&(e=!0);var o=null;return this.children.some((function(e){return e.prop.id===t&&(o=e,!0)})),!o&&e&&Y('button "'+t+'" not found in the navbar'),o},o.show=function(){this.container.classList.add("psv-navbar--open"),this.prop.visible=!0},o.hide=function(){this.container.classList.remove("psv-navbar--open"),this.prop.visible=!1},o.refreshUi=function(){if(t.prototype.refreshUi.call(this),!0===this.psv.prop.uiRefresh){var e=this.container.offsetWidth,o=0,n=[],i=[];if(this.children.forEach((function(t){t.prop.visible&&(o+=t.prop.width,n.push(t),t.prop.collapsable&&i.push(t))})),!n.length)return;e<o&&i.length>0?(i.forEach((function(t){return t.collapse()})),this.collapsed=i,this.getButton(wt.id).show(!1)):e>=o&&this.collapsed.length>0&&(this.collapsed.forEach((function(t){return t.uncollapse()})),this.collapsed=[],this.getButton(wt.id).hide(!1));var r=this.getButton(Vt.id,!1);r&&r.refreshUi()}},o.__cleanButtons=function(t){return!0===t?z(Rt.navbar):"string"==typeof t?t.split(/[ ,]/):t||[]},e}(pt),Xt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-loader-container")||this).loader=document.createElement("div"),o.loader.className="psv-loader",o.container.appendChild(o.loader),o.canvas=document.createElement("canvas"),o.canvas.className="psv-loader-canvas",o.canvas.width=o.loader.clientWidth*_t.pixelRatio,o.canvas.height=o.loader.clientWidth*_t.pixelRatio,o.loader.appendChild(o.canvas),o.prop=at({},o.prop,{tickness:(o.loader.offsetWidth-o.loader.clientWidth)/2*_t.pixelRatio,current:null}),o.refreshUi(),o.hide(),o}ct(e,t);var o=e.prototype;return o.destroy=function(){delete this.loader,delete this.canvas,t.prototype.destroy.call(this)},o.refreshUi=function(){if(this.prop.current!==(this.psv.config.loadingImg||this.psv.config.loadingTxt)){var t;if(this.prop.current&&this.loader.removeChild(this.loader.lastChild),this.psv.config.loadingImg?((t=document.createElement("img")).className="psv-loader-image",t.src=this.psv.config.loadingImg):this.psv.config.loadingTxt&&((t=document.createElement("div")).className="psv-loader-text",t.innerHTML=this.psv.config.loadingTxt),t){var e=Math.round(Math.sqrt(2*Math.pow((this.canvas.width/2-this.prop.tickness/2)/_t.pixelRatio,2)));t.style.maxWidth=e+"px",t.style.maxHeight=e+"px",this.loader.appendChild(t)}this.prop.current=this.psv.config.loadingImg||this.psv.config.loadingTxt}},o.setProgress=function(t){var e=this.canvas.getContext("2d");e.clearRect(0,0,this.canvas.width,this.canvas.height),e.lineWidth=this.prop.tickness,e.strokeStyle=O(this.loader,"color"),e.beginPath(),e.arc(this.canvas.width/2,this.canvas.height/2,this.canvas.width/2-this.prop.tickness/2,-Math.PI/2,x(t,0,100)/100*2*Math.PI-Math.PI/2),e.stroke(),this.psv.trigger(c.LOAD_PROGRESS,Math.round(t))},e}(pt),Bt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-notification")||this).prop=at({},o.prop,{visible:!1,timeout:null}),o.content=document.createElement("div"),o.content.className="psv-notification-content",o.container.appendChild(o.content),o.content.addEventListener("click",(function(){return o.hide()})),o}ct(e,t);var o=e.prototype;return o.destroy=function(){delete this.content,t.prototype.destroy.call(this)},o.show=function(t){var e=this;this.prop.timeout&&(clearTimeout(this.prop.timeout),this.prop.timeout=null),"string"==typeof t&&(t={content:t}),this.content.innerHTML=t.content,this.prop.visible=!0,this.container.classList.add("psv-notification--visible"),this.psv.trigger(c.SHOW_NOTIFICATION),t.timeout&&(this.prop.timeout=setTimeout((function(){return e.hide()}),t.timeout))},o.hide=function(){this.prop.visible&&(this.container.classList.remove("psv-notification--visible"),this.prop.visible=!1,this.psv.trigger(c.HIDE_NOTIFICATION))},e}(pt),Gt=function(t){function e(e){var o;return(o=t.call(this,e,"psv-overlay")||this).prop=at({},o.prop,{contentId:void 0,dissmisable:!0}),o.image=document.createElement("div"),o.image.className="psv-overlay-image",o.container.appendChild(o.image),o.text=document.createElement("div"),o.text.className="psv-overlay-text",o.container.appendChild(o.text),o.subtext=document.createElement("div"),o.subtext.className="psv-overlay-subtext",o.container.appendChild(o.subtext),o.container.addEventListener("mouseup",lt(o)),document.addEventListener("keydown",lt(o)),t.prototype.hide.call(lt(o)),o}ct(e,t);var o=e.prototype;return o.destroy=function(){document.removeEventListener("keydown",this),delete this.image,delete this.text,delete this.subtext,t.prototype.destroy.call(this)},o.handleEvent=function(t){switch(t.type){case"mouseup":this.prop.dissmisable&&this.hide();break;case"keydown":E(t)===d.Escape&&this.prop.dissmisable&&this.hide()}},o.isVisible=function(t){return this.prop.visible&&(!t||!this.prop.contentId||this.prop.contentId===t)},o.toggle=function(){throw new W("Overlay cannot be toggled")},o.show=function(e){"string"==typeof e&&(e={text:e}),this.prop.contentId=e.id,this.prop.dissmisable=!1!==e.dissmisable,this.image.innerHTML=e.image||"",this.text.innerHTML=e.text||"",this.subtext.innerHTML=e.subtext||"",t.prototype.show.call(this),this.psv.trigger(c.SHOW_OVERLAY,e.id)},o.hide=function(e){if(this.isVisible()&&(!e||!this.prop.contentId||this.prop.contentId===e)){var o=this.prop.contentId;t.prototype.hide.call(this),this.prop.contentId=void 0,this.psv.trigger(c.HIDE_OVERLAY,o)}},e}(pt),qt=function(t){function e(e){var o;(o=t.call(this,e,"psv-panel")||this).prop=at({},o.prop,{visible:!1,contentId:void 0,mouseX:0,mouseY:0,mousedown:!1,clickHandler:null,keyHandler:null,width:{}});var n=document.createElement("div");n.className="psv-panel-resizer",o.container.appendChild(n);var i=document.createElement("div");return i.className="psv-panel-close-button",o.container.appendChild(i),o.content=document.createElement("div"),o.content.className="psv-panel-content",o.container.appendChild(o.content),o.container.addEventListener(_t.mouseWheelEvent,(function(t){return t.stopPropagation()})),i.addEventListener("click",(function(){return o.hide()})),n.addEventListener("mousedown",lt(o)),n.addEventListener("touchstart",lt(o)),o.psv.container.addEventListener("mouseup",lt(o)),o.psv.container.addEventListener("touchend",lt(o)),o.psv.container.addEventListener("mousemove",lt(o)),o.psv.container.addEventListener("touchmove",lt(o)),document.addEventListener("keydown",lt(o)),o}ct(e,t);var o=e.prototype;return o.destroy=function(){this.psv.container.removeEventListener("mousemove",this),this.psv.container.removeEventListener("touchmove",this),this.psv.container.removeEventListener("mouseup",this),this.psv.container.removeEventListener("touchend",this),document.removeEventListener("keydown",this),delete this.prop,delete this.content,t.prototype.destroy.call(this)},o.handleEvent=function(t){switch(t.type){case"mousedown":this.__onMouseDown(t);break;case"touchstart":this.__onTouchStart(t);break;case"mousemove":this.__onMouseMove(t);break;case"touchmove":this.__onTouchMove(t);break;case"mouseup":case"touchend":this.__onMouseUp(t);break;case"keydown":E(t)===d.Escape&&this.hide()}},o.isVisible=function(t){return this.prop.visible&&(!t||!this.prop.contentId||this.prop.contentId===t)},o.toggle=function(){throw new W("Panel cannot be toggled")},o.show=function(t){var e=this,o=this.isVisible(t.id);"string"==typeof t&&(t={content:t}),this.prop.contentId=t.id,this.prop.visible=!0,this.prop.clickHandler&&(this.content.removeEventListener("click",this.prop.clickHandler),this.content.removeEventListener("keydown",this.prop.keyHandler),this.prop.clickHandler=null,this.prop.keyHandler=null),t.id&&this.prop.width[t.id]?this.container.style.width=this.prop.width[t.id]:t.width?this.container.style.width=t.width:this.container.style.width=null,this.content.innerHTML=t.content,this.content.scrollTop=0,this.container.classList.add("psv-panel--open"),f(this.content,"psv-panel-content--no-margin",!0===t.noMargin),t.clickHandler&&(this.prop.clickHandler=t.clickHandler,this.prop.keyHandler=function(e){E(e)===d.Enter&&t.clickHandler(e)},this.content.addEventListener("click",this.prop.clickHandler),this.content.addEventListener("keydown",this.prop.keyHandler),o||setTimeout((function(){var t;null==(t=e.content.querySelector("a,button,[tabindex]"))||t.focus()}),300)),this.psv.trigger(c.OPEN_PANEL,t.id)},o.hide=function(t){if(this.isVisible(t)){var e=this.prop.contentId;this.prop.visible=!1,this.prop.contentId=void 0,this.content.innerHTML=null,this.container.classList.remove("psv-panel--open"),this.prop.clickHandler&&(this.content.removeEventListener("click",this.prop.clickHandler),this.prop.clickHandler=null),this.psv.trigger(c.CLOSE_PANEL,e)}},o.__onMouseDown=function(t){t.stopPropagation(),this.__startResize(t)},o.__onTouchStart=function(t){t.stopPropagation(),this.__startResize(t.changedTouches[0])},o.__onMouseUp=function(t){this.prop.mousedown&&(t.stopPropagation(),this.prop.mousedown=!1,this.content.classList.remove("psv-panel-content--no-interaction"))},o.__onMouseMove=function(t){this.prop.mousedown&&(t.stopPropagation(),this.__resize(t))},o.__onTouchMove=function(t){this.prop.mousedown&&this.__resize(t.touches[0])},o.__startResize=function(t){this.prop.mouseX=t.clientX,this.prop.mouseY=t.clientY,this.prop.mousedown=!0,this.content.classList.add("psv-panel-content--no-interaction")},o.__resize=function(t){var e=t.clientX,o=t.clientY,n=Math.max(200,this.container.offsetWidth-(e-this.prop.mouseX))+"px";this.prop.contentId&&(this.prop.width[this.prop.contentId]=n),this.container.style.width=n,this.prop.mouseX=e,this.prop.mouseY=o},e}(pt),Kt=function(){function t(t){this.psv=t,this.config=t.config,this.prop=t.prop}return t.prototype.destroy=function(){delete this.psv,delete this.config,delete this.prop},t}(),Qt=new e.Vector2,$t=new e.Vector3,Jt=new e.Euler(0,0,0,"ZXY"),te=function(t){function o(e){return t.call(this,e)||this}ct(o,t);var n=o.prototype;return n.fovToZoomLevel=function(t){var e=Math.round((t-this.config.minFov)/(this.config.maxFov-this.config.minFov)*100);return e-2*(e-50)},n.zoomLevelToFov=function(t){return this.config.maxFov+t/100*(this.config.minFov-this.config.maxFov)},n.vFovToHFov=function(t){return e.Math.radToDeg(2*Math.atan(Math.tan(e.Math.degToRad(t)/2)*this.prop.aspect))},n.speedToDuration=function(t,e){if(t&&"number"==typeof t)return Math.abs(t);var o=t?J(t):this.config.autorotateSpeed;return e/Math.abs(o)*1e3},n.textureCoordsToSphericalCoords=function(t){var e=this.prop.panoData;if(!e)throw new W("Current adapter does not support texture coordinates.");var o=(t.x+e.croppedX)/e.fullWidth*Math.PI*2,n=(t.y+e.croppedY)/e.fullHeight*Math.PI,i={longitude:o>=Math.PI?o-Math.PI:o+Math.PI,latitude:Math.PI/2-n};return Jt.equals(this.psv.renderer.mesh.rotation)&&Jt.equals(this.psv.renderer.meshContainer.rotation)?i:(this.sphericalCoordsToVector3(i,$t),$t.applyEuler(this.psv.renderer.mesh.rotation),$t.applyEuler(this.psv.renderer.meshContainer.rotation),this.vector3ToSphericalCoords($t))},n.sphericalCoordsToTextureCoords=function(t){var e=this.prop.panoData;if(!e)throw new W("Current adapter does not support texture coordinates.");Jt.equals(this.psv.renderer.mesh.rotation)&&Jt.equals(this.psv.renderer.meshContainer.rotation)||(this.sphericalCoordsToVector3(t,$t),nt($t,this.psv.renderer.meshContainer.rotation),nt($t,this.psv.renderer.mesh.rotation),t=this.vector3ToSphericalCoords($t));var o=t.longitude/Math.PI/2*e.fullWidth,n=t.latitude/Math.PI*e.fullHeight;return{x:Math.round(t.longitude<Math.PI?o+e.fullWidth/2:o-e.fullWidth/2)-e.croppedX,y:Math.round(e.fullHeight/2-n)-e.croppedY}},n.sphericalCoordsToVector3=function(t,o){return o||(o=new e.Vector3),o.x=i*-Math.cos(t.latitude)*Math.sin(t.longitude),o.y=i*Math.sin(t.latitude),o.z=i*Math.cos(t.latitude)*Math.cos(t.longitude),o},n.vector3ToSphericalCoords=function(t){var e=Math.acos(t.y/Math.sqrt(t.x*t.x+t.y*t.y+t.z*t.z)),o=Math.atan2(t.x,t.z);return{longitude:o<0?-o:2*Math.PI-o,latitude:Math.PI/2-e}},n.viewerCoordsToVector3=function(t){var e=this.getIntersections(t).filter((function(t){return t.object.userData.psvSphere}));return e?e.point:null},n.vector3ToViewerCoords=function(t){var e=t.clone();return e.project(this.psv.renderer.camera),{x:Math.round((e.x+1)/2*this.prop.size.width),y:Math.round((1-e.y)/2*this.prop.size.height)}},n.sphericalCoordsToViewerCoords=function(t){return this.vector3ToViewerCoords(this.sphericalCoordsToVector3(t,$t))},n.getIntersections=function(t){return Qt.x=2*t.x/this.prop.size.width-1,Qt.y=-2*t.y/this.prop.size.height+1,this.psv.renderer.raycaster.setFromCamera(Qt,this.psv.renderer.camera),this.psv.renderer.raycaster.intersectObjects(this.psv.renderer.scene.children,!0).filter((function(t){return!!t.object.userData}))},n.cleanPosition=function(t){return void 0!==t.x&&void 0!==t.y?this.textureCoordsToSphericalCoords(t):{longitude:tt(t.longitude),latitude:tt(t.latitude,!0)}},n.cleanSphereCorrection=function(t){return{pan:tt((null==t?void 0:t.pan)||0),tilt:tt((null==t?void 0:t.tilt)||0,!0),roll:tt((null==t?void 0:t.roll)||0,!0,!1)}},n.cleanPanoramaPose=function(t){return{pan:e.Math.degToRad((null==t?void 0:t.poseHeading)||0),tilt:e.Math.degToRad((null==t?void 0:t.posePitch)||0),roll:e.Math.degToRad((null==t?void 0:t.poseRoll)||0)}},o}(Kt),ee=function(t){function o(e){var o;return(o=t.call(this,e)||this).state={moveThreshold:4*_t.pixelRatio,keyboardEnabled:!1,moving:!1,zooming:!1,startMouseX:0,startMouseY:0,mouseX:0,mouseY:0,mouseHistory:[],pinchDist:0,keyHandler:new bt,ctrlKeyDown:!1,dblclickData:null,dblclickTimeout:null,longtouchTimeout:null,twofingersTimeout:null,ctrlZoomTimeout:null},o.__onResize=D((function(){return o.psv.autoSize()}),50),o}ct(o,t);var i=o.prototype;return i.init=function(){window.addEventListener("resize",this),window.addEventListener("keydown",this),window.addEventListener("keyup",this),this.psv.container.addEventListener("mouseenter",this),this.psv.container.addEventListener("mousedown",this),this.psv.container.addEventListener("mouseleave",this),this.psv.container.addEventListener("mousemove",this),window.addEventListener("mouseup",this),this.psv.container.addEventListener("touchstart",this),this.psv.container.addEventListener("touchmove",this),window.addEventListener("touchend",this),this.psv.container.addEventListener(_t.mouseWheelEvent,this),_t.fullscreenEvent&&document.addEventListener(_t.fullscreenEvent,this)},i.destroy=function(){window.removeEventListener("resize",this),window.removeEventListener("keydown",this),window.removeEventListener("keyup",this),this.psv.container.removeEventListener("mouseenter",this),this.psv.container.removeEventListener("mousedown",this),this.psv.container.removeEventListener("mouseleave",this),this.psv.container.removeEventListener("mousemove",this),window.removeEventListener("mouseup",this),this.psv.container.removeEventListener("touchstart",this),this.psv.container.removeEventListener("touchmove",this),window.removeEventListener("touchend",this),this.psv.container.removeEventListener(_t.mouseWheelEvent,this),_t.fullscreenEvent&&document.removeEventListener(_t.fullscreenEvent,this),clearTimeout(this.state.dblclickTimeout),clearTimeout(this.state.longtouchTimeout),clearTimeout(this.state.twofingersTimeout),clearTimeout(this.state.ctrlZoomTimeout),delete this.state,t.prototype.destroy.call(this)},i.handleEvent=function(t){switch(t.type){case"resize":this.__onResize();break;case"keydown":this.__onKeyDown(t);break;case"keyup":this.__onKeyUp();break;case"mouseup":this.__onMouseUp(t);break;case"touchend":this.__onTouchEnd(t);break;case _t.fullscreenEvent:this.__fullscreenToggled()}if(!g(t.target,".psv-navbar")&&!g(t.target,".psv-panel"))switch(t.type){case"mousedown":this.__onMouseDown(t);break;case"mouseenter":this.__onMouseEnter(t);break;case"mouseleave":this.__onMouseLeave(t);break;case"mousemove":this.__onMouseMove(t);break;case"touchstart":this.__onTouchStart(t);break;case"touchmove":this.__onTouchMove(t);break;case _t.mouseWheelEvent:this.__onMouseWheel(t)}},i.enableKeyboard=function(){this.state.keyboardEnabled=!0},i.disableKeyboard=function(){this.state.keyboardEnabled=!1},i.__onKeyDown=function(t){var e=E(t);if(this.config.mousewheelCtrlKey&&(this.state.ctrlKeyDown=e===d.Control,this.state.ctrlKeyDown&&(clearTimeout(this.state.ctrlZoomTimeout),this.psv.overlay.hide(p.CTRL_ZOOM))),this.state.keyboardEnabled)if(this.config.keyboard[e]===a.TOGGLE_AUTOROTATE)this.psv.toggleAutorotate();else if(this.config.keyboard[e]&&!this.state.keyHandler.time){switch(this.config.keyboard[e]){case a.ROTATE_LAT_UP:this.psv.dynamics.position.roll({latitude:!1});break;case a.ROTATE_LAT_DOWN:this.psv.dynamics.position.roll({latitude:!0});break;case a.ROTATE_LONG_RIGHT:this.psv.dynamics.position.roll({longitude:!1});break;case a.ROTATE_LONG_LEFT:this.psv.dynamics.position.roll({longitude:!0});break;case a.ZOOM_IN:this.psv.dynamics.zoom.roll(!1);break;case a.ZOOM_OUT:this.psv.dynamics.zoom.roll(!0)}this.state.keyHandler.down()}},i.__onKeyUp=function(){var t=this;this.state.ctrlKeyDown=!1,this.state.keyboardEnabled&&this.state.keyHandler.up((function(){t.psv.dynamics.position.stop(),t.psv.dynamics.zoom.stop()}))},i.__onMouseDown=function(t){this.config.mousemove&&!this.config.captureCursor&&this.__startMove(t)},i.__onMouseEnter=function(t){this.config.mousemove&&this.config.captureCursor&&this.__startMove(t)},i.__onMouseUp=function(t){this.config.mousemove&&!this.config.captureCursor&&this.__stopMove(t)},i.__onMouseLeave=function(t){this.config.mousemove&&this.config.captureCursor&&this.__stopMove(t)},i.__onMouseMove=function(t){if(this.config.mousemove&&(0!==t.buttons?(t.preventDefault(),this.__move(t)):this.config.captureCursor&&this.__moveAbsolute(t)),!R(this.prop.objectsObservers)){var e=w(this.psv.container),o={x:t.clientX-e.left,y:t.clientY-e.top},n=this.psv.dataHelper.getIntersections(o),i=function(e,n,i){e.listener.handleEvent(new CustomEvent(i,{detail:{originalEvent:t,object:e.object,data:e.object.userData[n],viewerPoint:o}}))};N(this.prop.objectsObservers,(function(t,e){var o=n.find((function(t){return t.object.userData[e]}));o?(t.object&&o.object!==t.object&&(i(t,e,l.LEAVE_OBJECT),delete t.object),t.object?i(t,e,l.HOVER_OBJECT):(t.object=o.object,i(t,e,l.ENTER_OBJECT))):t.object&&(i(t,e,l.LEAVE_OBJECT),delete t.object)}))}},i.__onTouchStart=function(t){var e=this;this.config.mousemove&&(1===t.touches.length?(this.config.touchmoveTwoFingers||(this.__startMove(t.touches[0]),t.preventDefault()),this.prop.longtouchTimeout||(this.prop.longtouchTimeout=setTimeout((function(){e.__click(t.touches[0],!0),e.prop.longtouchTimeout=null}),500))):2===t.touches.length&&(this.__cancelLongTouch(),this.__cancelTwoFingersOverlay(),this.__startMoveZoom(t),t.preventDefault()))},i.__onTouchEnd=function(t){this.config.mousemove&&(this.__cancelLongTouch(),this.__cancelTwoFingersOverlay(),1===t.touches.length?this.__stopMoveZoom():0===t.touches.length&&this.__stopMove(t.changedTouches[0]))},i.__onTouchMove=function(t){var e=this;this.config.mousemove&&(this.__cancelLongTouch(),1===t.touches.length?this.config.touchmoveTwoFingers?this.prop.twofingersTimeout||(this.prop.twofingersTimeout=setTimeout((function(){e.psv.overlay.show({id:p.TWO_FINGERS,image:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><path fill="currentColor" d="M33.38 33.2a1.96 1.96 0 0 0 1.5-3.23 10.61 10.61 0 0 1 7.18-17.51c.7-.06 1.31-.49 1.61-1.12a13.02 13.02 0 0 1 11.74-7.43c7.14 0 12.96 5.8 12.96 12.9 0 3.07-1.1 6.05-3.1 8.38-.7.82-.61 2.05.21 2.76.83.7 2.07.6 2.78-.22a16.77 16.77 0 0 0 4.04-10.91C72.3 7.54 64.72 0 55.4 0a16.98 16.98 0 0 0-14.79 8.7 14.6 14.6 0 0 0-12.23 14.36c0 3.46 1.25 6.82 3.5 9.45.4.45.94.69 1.5.69m45.74 43.55a22.13 22.13 0 0 1-5.23 12.4c-4 4.55-9.53 6.86-16.42 6.86-12.6 0-20.1-10.8-20.17-10.91a1.82 1.82 0 0 0-.08-.1c-5.3-6.83-14.55-23.82-17.27-28.87-.05-.1 0-.21.02-.23a6.3 6.3 0 0 1 8.24 1.85l9.38 12.59a1.97 1.97 0 0 0 3.54-1.17V25.34a4 4 0 0 1 1.19-2.87 3.32 3.32 0 0 1 2.4-.95c1.88.05 3.4 1.82 3.4 3.94v24.32a1.96 1.96 0 0 0 3.93 0v-33.1a3.5 3.5 0 0 1 7 0v35.39a1.96 1.96 0 0 0 3.93 0v-.44c.05-2.05 1.6-3.7 3.49-3.7 1.93 0 3.5 1.7 3.5 3.82v5.63c0 .24.04.48.13.71l.1.26a1.97 1.97 0 0 0 3.76-.37c.33-1.78 1.77-3.07 3.43-3.07 1.9 0 3.45 1.67 3.5 3.74l-1.77 18.1zM77.39 51c-1.25 0-2.45.32-3.5.9v-.15c0-4.27-3.33-7.74-7.42-7.74-1.26 0-2.45.33-3.5.9V16.69a7.42 7.42 0 0 0-14.85 0v1.86a7 7 0 0 0-3.28-.94 7.21 7.21 0 0 0-5.26 2.07 7.92 7.92 0 0 0-2.38 5.67v37.9l-5.83-7.82a10.2 10.2 0 0 0-13.35-2.92 4.1 4.1 0 0 0-1.53 5.48C20 64.52 28.74 80.45 34.07 87.34c.72 1.04 9.02 12.59 23.4 12.59 7.96 0 14.66-2.84 19.38-8.2a26.06 26.06 0 0 0 6.18-14.6l1.78-18.2v-.2c0-4.26-3.32-7.73-7.42-7.73z"/>\x3c!--Created by AomAm from the Noun Project--\x3e</svg>\n',text:e.config.lang.twoFingers})}),100)):(t.preventDefault(),this.__move(t.touches[0])):2===t.touches.length&&(t.preventDefault(),this.__moveZoom(t),this.__cancelTwoFingersOverlay()))},i.__cancelLongTouch=function(){this.prop.longtouchTimeout&&(clearTimeout(this.prop.longtouchTimeout),this.prop.longtouchTimeout=null)},i.__cancelTwoFingersOverlay=function(){this.prop.twofingersTimeout&&(clearTimeout(this.prop.twofingersTimeout),this.prop.twofingersTimeout=null),this.psv.overlay.hide(p.TWO_FINGERS)},i.__onMouseWheel=function(t){var e=this;if(this.config.mousewheel){if(this.config.mousewheelCtrlKey&&!this.state.ctrlKeyDown)return this.psv.overlay.show({id:p.CTRL_ZOOM,image:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="10 17 79 79"><path fill="currentColor" d="M38.1 29.27c-.24 0-.44.2-.44.45v10.7a.45.45 0 00.9 0v-10.7c0-.25-.2-.45-.45-.45zm10.2 26.66a11.54 11.54 0 01-8.48-6.14.45.45 0 10-.8.41 12.45 12.45 0 009.22 6.62.45.45 0 00.07-.9zm24.55-13.08a23.04 23.04 0 00-22.56-23v7.07l-.01.05a2.83 2.83 0 012.39 2.78v14.03l.09-.02h8.84v-9.22a.45.45 0 11.9 0v9.22h10.35v-.9zm0 27.33V44.66H62.5c-.02 2.01-.52 4-1.47 5.76a.45.45 0 01-.61.18.45.45 0 01-.19-.61 11.54 11.54 0 001.36-5.33h-8.83l-.1-.01a2.83 2.83 0 01-2.83 2.84h-.04-.04a2.83 2.83 0 01-2.83-2.83v-14.9a2.82 2.82 0 012.47-2.8v-7.11a23.04 23.04 0 00-22.57 23v.91h14.72V29.88a8.2 8.2 0 015.02-7.57c.22-.1.5.01.59.24.1.23-.01.5-.24.6a7.3 7.3 0 00-4.47 6.73v13.88h3.9a.45.45 0 110 .9h-3.9v.15a7.32 7.32 0 0011.23 6.17.45.45 0 01.49.76 8.22 8.22 0 01-12.62-6.93v-.15H26.82v25.52a23.04 23.04 0 0023.01 23.01 23.04 23.04 0 0023.02-23.01zm1.8-27.33v27.33A24.85 24.85 0 0149.84 95a24.85 24.85 0 01-24.82-24.82V42.85a24.85 24.85 0 0124.82-24.82 24.85 24.85 0 0124.83 24.82zM57.98 29.88v9.36a.45.45 0 11-.9 0v-9.36a7.28 7.28 0 00-3.4-6.17.45.45 0 01.49-.76 8.18 8.18 0 013.8 6.93z"/>\x3c!-- Created by Icon Island from the Noun Project --\x3e</svg>\n',text:this.config.lang.ctrlZoom}),clearTimeout(this.state.ctrlZoomTimeout),void(this.state.ctrlZoomTimeout=setTimeout((function(){return e.psv.overlay.hide(p.CTRL_ZOOM)}),2e3));t.preventDefault(),t.stopPropagation();var o=5*L(t).spinY*this.config.zoomSpeed;0!==o&&this.psv.dynamics.zoom.step(-o,5)}},i.__fullscreenToggled=function(t){this.prop.fullscreen=void 0!==t?t:b(this.psv.container),this.config.keyboard&&(this.prop.fullscreen?this.psv.startKeyboardControl():this.psv.stopKeyboardControl()),this.psv.trigger(c.FULLSCREEN_UPDATED,this.prop.fullscreen)},i.__startMove=function(t){var e=this;this.psv.stopAutorotate(),this.psv.stopAnimation().then((function(){e.state.mouseX=t.clientX,e.state.mouseY=t.clientY,e.state.startMouseX=e.state.mouseX,e.state.startMouseY=e.state.mouseY,e.state.moving=!0,e.state.zooming=!1,e.state.mouseHistory.length=0,e.__logMouseMove(t)}))},i.__startMoveZoom=function(t){var e={x:t.touches[0].clientX,y:t.touches[0].clientY},o={x:t.touches[1].clientX,y:t.touches[1].clientY};this.state.pinchDist=A(e,o),this.state.mouseX=(e.x+o.x)/2,this.state.mouseY=(e.y+o.y)/2,this.state.startMouseX=this.state.mouseX,this.state.startMouseY=this.state.mouseY,this.state.moving=!0,this.state.zooming=!0},i.__stopMove=function(t){if(!g(t.target,".psv-container"))return this.state.moving=!1,void(this.state.mouseHistory.length=0);this.state.moving&&(Math.abs(t.clientX-this.state.startMouseX)<this.state.moveThreshold&&Math.abs(t.clientY-this.state.startMouseY)<this.state.moveThreshold?(this.__click(t),this.state.moving=!1):this.config.moveInertia?(this.__logMouseMove(t),this.__stopMoveInertia(t)):this.state.moving=!1,this.state.mouseHistory.length=0)},i.__stopMoveZoom=function(){this.state.mouseHistory.length=0,this.state.moving=!1,this.state.zooming=!1},i.__stopMoveInertia=function(t){var e=this,o=t.clientX-this.state.mouseHistory[0][1],i=t.clientY-this.state.mouseHistory[0][2],r=Math.sqrt(o*o+i*i);this.prop.animationPromise=new rt({properties:{clientX:{start:t.clientX,end:t.clientX+o},clientY:{start:t.clientY,end:t.clientY+i}},duration:r*n/100,easing:"outCirc",onTick:function(t){e.__move(t,!1)}}),this.prop.animationPromise.then((function(){e.state.moving=!1}))},i.__click=function(t,e){var o=this;void 0===e&&(e=!1);var n=this.psv.container.getBoundingClientRect(),i={rightclick:e||2===t.button,target:t.target,clientX:t.clientX,clientY:t.clientY,viewerX:t.clientX-n.left,viewerY:t.clientY-n.top},r=this.psv.dataHelper.getIntersections({x:i.viewerX,y:i.viewerY}),s=r.find((function(t){return t.object.userData.psvSphere}));if(s){var a=this.psv.dataHelper.vector3ToSphericalCoords(s.point);i.longitude=a.longitude,i.latitude=a.latitude,i.objects=r.map((function(t){return t.object})).filter((function(t){return!t.userData.psvSphere}));try{var h=this.psv.dataHelper.sphericalCoordsToTextureCoords(i);i.textureX=h.x,i.textureY=h.y}catch(t){i.textureX=NaN,i.textureY=NaN}this.state.dblclickTimeout?(Math.abs(this.state.dblclickData.clientX-i.clientX)<this.state.moveThreshold&&Math.abs(this.state.dblclickData.clientY-i.clientY)<this.state.moveThreshold&&this.psv.trigger(c.DOUBLE_CLICK,this.state.dblclickData),clearTimeout(this.state.dblclickTimeout),this.state.dblclickTimeout=null,this.state.dblclickData=null):(this.psv.trigger(c.CLICK,i),this.state.dblclickData=z(i),this.state.dblclickTimeout=setTimeout((function(){o.state.dblclickTimeout=null,o.state.dblclickData=null}),300))}},i.__move=function(t,o){if(this.state.moving){var n=t.clientX,i=t.clientY,r={longitude:(n-this.state.mouseX)/this.prop.size.width*this.config.moveSpeed*e.Math.degToRad(this.prop.hFov),latitude:(i-this.state.mouseY)/this.prop.size.height*this.config.moveSpeed*e.Math.degToRad(this.prop.vFov)},s=this.psv.getPosition();this.psv.rotate({longitude:s.longitude-r.longitude,latitude:s.latitude+r.latitude}),this.state.mouseX=n,this.state.mouseY=i,!1!==o&&this.__logMouseMove(t)}},i.__moveAbsolute=function(t){if(this.state.moving){var e=this.psv.container.getBoundingClientRect();this.psv.dynamics.position.goto({longitude:((t.clientX-e.left)/e.width-.5)*Math.PI*2,latitude:-((t.clientY-e.top)/e.height-.5)*Math.PI},10)}},i.__moveZoom=function(t){if(this.state.zooming&&this.state.moving){var e={x:t.touches[0].clientX,y:t.touches[0].clientY},o={x:t.touches[1].clientX,y:t.touches[1].clientY},n=A(e,o),i=80*(n-this.state.pinchDist)/this.prop.size.width*this.config.zoomSpeed;this.psv.zoom(this.psv.getZoomLevel()+i),this.__move({clientX:(e.x+o.x)/2,clientY:(e.y+o.y)/2}),this.state.pinchDist=n}},i.__logMouseMove=function(t){var e=Date.now();this.state.mouseHistory.push([e,t.clientX,t.clientY]);for(var o=null,i=0;i<this.state.mouseHistory.length;)this.state.mouseHistory[0][i]<e-n?this.state.mouseHistory.splice(i,1):o&&this.state.mouseHistory[0][i]-o>30?(this.state.mouseHistory.splice(0,i),i=0,o=this.state.mouseHistory[0][i]):(i++,o=this.state.mouseHistory[0][i])},o}(Kt),oe=function(t){function o(o){var n,i;return(i=t.call(this,o)||this).renderer=new e.WebGLRenderer({alpha:!0,antialias:!0}),i.renderer.setPixelRatio(_t.pixelRatio),i.renderer.domElement.className="psv-canvas",i.scene=new e.Scene,i.camera=new e.PerspectiveCamera(50,16/9,1,20),i.mesh=i.psv.adapter.createMesh(),i.mesh.userData=((n={}).psvSphere=!0,n),i.meshContainer=new e.Group,i.meshContainer.add(i.mesh),i.scene.add(i.meshContainer),i.raycaster=new e.Raycaster,i.timestamp=null,i.ready=!1,i.canvasContainer=document.createElement("div"),i.canvasContainer.className="psv-canvas-container",i.canvasContainer.style.background=i.psv.config.canvasBackground,i.canvasContainer.style.cursor=i.psv.config.mousemove?"move":"default",i.canvasContainer.appendChild(i.renderer.domElement),i.psv.container.appendChild(i.canvasContainer),o.on(c.SIZE_UPDATED,lt(i)),o.on(c.ZOOM_UPDATED,lt(i)),o.on(c.POSITION_UPDATED,lt(i)),o.on(c.CONFIG_CHANGED,lt(i)),i.hide(),i}ct(o,t);var n=o.prototype;return n.destroy=function(){this.renderer.setAnimationLoop(null),this.__cleanTHREEScene(this.scene),this.psv.container.removeChild(this.canvasContainer),delete this.canvasContainer,delete this.renderer,delete this.scene,delete this.camera,delete this.mesh,delete this.meshContainer,delete this.raycaster,t.prototype.destroy.call(this)},n.handleEvent=function(t){switch(t.type){case c.SIZE_UPDATED:this.__onSizeUpdated();break;case c.ZOOM_UPDATED:this.__onZoomUpdated();break;case c.POSITION_UPDATED:this.__onPositionUpdated();break;case c.CONFIG_CHANGED:-1!==t.args[0].indexOf("fisheye")&&this.__onPositionUpdated(),-1!==t.args[0].indexOf("mousemove")&&(this.canvasContainer.style.cursor=this.psv.config.mousemove?"move":"default")}},n.hide=function(){this.canvasContainer.style.opacity=0},n.show=function(){this.canvasContainer.style.opacity=1},n.__onSizeUpdated=function(){this.renderer.setSize(this.prop.size.width,this.prop.size.height),this.camera.aspect=this.prop.aspect,this.camera.updateProjectionMatrix(),this.prop.needsUpdate=!0},n.__onZoomUpdated=function(){this.camera.fov=this.prop.vFov,this.camera.updateProjectionMatrix(),this.prop.needsUpdate=!0},n.__onPositionUpdated=function(){this.camera.position.set(0,0,0),this.camera.lookAt(this.prop.direction),this.config.fisheye&&this.camera.position.copy(this.prop.direction).multiplyScalar(this.config.fisheye/2).negate(),this.prop.needsUpdate=!0},n.__renderLoop=function(t){var e=null!==this.timestamp?t-this.timestamp:0;this.timestamp=t,this.psv.trigger(c.BEFORE_RENDER,t,e),N(this.psv.dynamics,(function(t){return t.update(e)})),this.prop.needsUpdate&&(this.render(),this.prop.needsUpdate=!1)},n.render=function(){this.renderer.render(this.scene,this.camera),this.psv.trigger(c.RENDER)},n.setTexture=function(t){var e=this;this.prop.panoData=t.panoData,this.psv.adapter.setTexture(this.mesh,t),this.ready||(this.renderer.setAnimationLoop((function(t){return e.__renderLoop(t)})),this.ready=!0),this.psv.needsUpdate(),this.psv.trigger(c.PANORAMA_LOADED)},n.setPanoramaPose=function(t,e){void 0===e&&(e=this.mesh);var o=this.psv.dataHelper.cleanPanoramaPose(t);e.rotation.set(-o.tilt,-o.pan,-o.roll,"ZXY")},n.setSphereCorrection=function(t,e){void 0===e&&(e=this.meshContainer);var o=this.psv.dataHelper.cleanSphereCorrection(t);e.rotation.set(o.tilt,o.pan,o.roll,"ZXY")},n.transition=function(t,o){var n=this,i=X(o),r="zoom"in o,s=new e.Group,a=this.psv.adapter.createMesh(.5);if(this.psv.adapter.setTexture(a,t,!0),this.psv.adapter.setTextureOpacity(a,0),this.setPanoramaPose(t.panoData,a),this.setSphereCorrection(o.sphereCorrection,s),i){var c=this.psv.dataHelper.cleanPosition(o),h=this.psv.getPosition(),l=new e.Vector3(0,1,0);s.rotateOnWorldAxis(l,c.longitude-h.longitude);var p=new e.Vector3(0,1,0).cross(this.camera.getWorldDirection(new e.Vector3)).normalize();s.rotateOnWorldAxis(p,c.latitude-h.latitude)}s.add(a),this.scene.add(s);var u=new rt({properties:{opacity:{start:0,end:1},zoom:r?{start:this.psv.getZoomLevel(),end:o.zoom}:void 0},duration:o.transition,easing:"outCubic",onTick:function(t){n.psv.adapter.setTextureOpacity(a,t.opacity),n.psv.adapter.setTextureOpacity(n.mesh,1-t.opacity),r&&n.psv.zoom(t.zoom),n.psv.needsUpdate()}});return u.then((function(e){e?(n.setTexture(t),n.psv.adapter.setTextureOpacity(n.mesh,1),n.setPanoramaPose(t.panoData),n.setSphereCorrection(o.sphereCorrection),i&&n.psv.rotate(o)):n.psv.adapter.disposeTexture(t),n.scene.remove(s),a.geometry.dispose(),a.geometry=null})),u},n.__cleanTHREEScene=function(t){var o=this;t.traverse((function(n){n.geometry&&n.geometry.dispose(),n.material&&(Array.isArray(n.material)?n.material.forEach((function(t){t.map&&t.map.dispose(),t.dispose()})):(n.material.map&&n.material.map.dispose(),n.material.dispose())),!n.dispose||n instanceof e.Scene||n.dispose(),n!==t&&o.__cleanTHREEScene(n)}))},o}(Kt),ne=function(t){function o(o){var n;return(n=t.call(this,o)||this).loader=new e.FileLoader,n.loader.setResponseType("blob"),n.config.withCredentials&&n.loader.setWithCredentials(!0),n.config.requestHeaders&&"object"==typeof n.config.requestHeaders&&n.loader.setRequestHeader(n.config.requestHeaders),n}ct(o,t);var n=o.prototype;return n.destroy=function(){this.abortLoading(),t.prototype.destroy.call(this)},n.loadTexture=function(t,e){return this.psv.adapter.loadTexture(t,e)},n.abortLoading=function(){},n.loadFile=function(t,e){var o=this;return this.config.requestHeaders&&"function"==typeof this.config.requestHeaders&&this.loader.setRequestHeader(this.config.requestHeaders(t)),new Promise((function(n,i){var r=0;e&&e(r),o.loader.load(t,(function(t){r=100,e&&e(r),n(t)}),(function(t){if(t.lengthComputable){var o=t.loaded/t.total*100;o>r&&(r=o,e&&e(r))}}),(function(t){i(t)}))}))},n.loadImage=function(t,e){return this.loadFile(t,e).then((function(t){return new Promise((function(e,o){var n=document.createElementNS("http://www.w3.org/1999/xhtml","img");n.onload=function(){URL.revokeObjectURL(n.src),e(n)},n.onerror=o,n.src=URL.createObjectURL(t)}))}))},n.preloadPanorama=function(t){return this.psv.adapter.supportsPreload(t)?this.psv.adapter.loadTexture(t):Promise.resolve()},o}(Kt),ie=0,re=1,se=2,ae=3,ce=function(t){function e(e,o){var n;return(n=t.call(this,e,"psv-tooltip")||this).prop=at({},n.prop,o,{state:ie,width:0,height:0,pos:"",data:null}),n.content=document.createElement("div"),n.content.className="psv-tooltip-content",n.container.appendChild(n.content),n.arrow=document.createElement("div"),n.arrow.className="psv-tooltip-arrow",n.container.appendChild(n.arrow),n.container.addEventListener("transitionend",lt(n)),n.container.style.top="-1000px",n.container.style.left="-1000px",n}ct(e,t);var o=e.prototype;return o.destroy=function(){delete this.arrow,delete this.content,t.prototype.destroy.call(this)},o.handleEvent=function(t){if("transitionend"===t.type)this.__onTransitionEnd(t)},o.toggle=function(){throw new W("Tooltip cannot be toggled")},o.show=function(t){if(this.prop.state!==ie)throw new W("Initialized tooltip cannot be re-initialized");t.className&&m(this.container,t.className),this.content.innerHTML=t.content;var e=this.container.getBoundingClientRect();this.prop.width=e.right-e.left,this.prop.height=e.bottom-e.top,this.prop.state=ae,this.move(t),this.prop.data=t.data,this.prop.state=re,this.psv.trigger(c.SHOW_TOOLTIP,this.prop.data,this)},o.move=function(t){if(this.prop.state!==re&&this.prop.state!==ae)throw new W("Uninitialized tooltip cannot be moved");var e=this.container,o=this.arrow,n={posClass:$(t.position,"top center",!1),width:this.prop.width,height:this.prop.height,top:0,left:0,arrowTop:0,arrowLeft:0};this.__computeTooltipPosition(n,t);var i=!1;n.top<this.prop.offset?(n.posClass[0]="bottom",i=!0):n.top+n.height>this.psv.prop.size.height-this.prop.offset&&(n.posClass[0]="top",i=!0),n.left<this.prop.offset?(n.posClass[1]="right",i=!0):n.left+n.width>this.psv.prop.size.width-this.prop.offset&&(n.posClass[1]="left",i=!0),i&&this.__computeTooltipPosition(n,t),e.style.top=n.top+"px",e.style.left=n.left+"px",o.style.top=n.arrowTop+"px",o.style.left=n.arrowLeft+"px";var r=n.posClass.join("-");r!==this.prop.pos&&(e.classList.remove("psv-tooltip--"+this.prop.pos),this.prop.pos=r,e.classList.add("psv-tooltip--"+this.prop.pos))},o.hide=function(){this.container.classList.remove("psv-tooltip--visible"),this.prop.state=se,this.psv.trigger(c.HIDE_TOOLTIP,this.prop.data)},o.__onTransitionEnd=function(t){if("transform"===t.propertyName)switch(this.prop.state){case re:this.container.classList.add("psv-tooltip--visible"),this.prop.state=ae;break;case se:this.prop.state=ie,this.destroy()}},o.__computeTooltipPosition=function(t,e){var o=!1;switch(e.box||(e.box={width:0,height:0}),t.posClass[0]){case"bottom":t.top=e.top+e.box.height+this.prop.offset+this.prop.arrow,t.arrowTop=2*-this.prop.arrow,o=!0;break;case"center":t.top=e.top+e.box.height/2-t.height/2,t.arrowTop=t.height/2-this.prop.arrow;break;case"top":t.top=e.top-t.height-this.prop.offset-this.prop.arrow,t.arrowTop=t.height,o=!0}switch(t.posClass[1]){case"right":o?(t.left=e.left+e.box.width/2-this.prop.offset-this.prop.arrow,t.arrowLeft=this.prop.offset):(t.left=e.left+e.box.width+this.prop.offset+this.prop.arrow,t.arrowLeft=2*-this.prop.arrow);break;case"center":t.left=e.left+e.box.width/2-t.width/2,t.arrowLeft=t.width/2-this.prop.arrow;break;case"left":o?(t.left=e.left-t.width+e.box.width/2+this.prop.offset+this.prop.arrow,t.arrowLeft=t.width-this.prop.offset-2*this.prop.arrow):(t.left=e.left-t.width-this.prop.offset-this.prop.arrow,t.arrowLeft=t.width)}},e}(pt),he=function(t){function e(e){var o;o=t.call(this,e)||this;var n=new ce(o.psv);return o.size={arrow:parseInt(O(n.arrow,"borderTopWidth"),10),offset:parseInt(O(n.container,"outlineWidth"),10)},n.destroy(),o}ct(e,t);var o=e.prototype;return o.destroy=function(){delete this.size,t.prototype.destroy.call(this)},o.create=function(t){var e=new ce(this.psv,this.size);return e.show(t),e},e}(Kt),le=function(){function t(e,o,n,i){void 0===o&&(o=0),void 0===n&&(n=-1/0),void 0===i&&(i=1/0),this.fn=e,this.mode=t.STOP,this.speed=0,this.speedMult=1,this.currentSpeed=0,this.target=0,this.current=o,this.min=n,this.max=i,this.fn&&this.fn(o)}var e=t.prototype;return e.setSpeed=function(t){this.speed=t},e.goto=function(e,o){void 0===o&&(o=1),this.mode=t.POSITION,this.target=x(e,this.min,this.max),this.speedMult=o},e.step=function(e,o){void 0===o&&(o=1),this.mode!==t.POSITION&&(this.target=this.current),this.goto(this.target+e,o)},e.roll=function(e,o){void 0===e&&(e=!1),void 0===o&&(o=1),this.mode=t.INFINITE,this.target=e?-1/0:1/0,this.speedMult=o},e.stop=function(){this.mode=t.STOP},e.setValue=function(e){var o=x(e,this.min,this.max);return this.target=o,this.mode=t.STOP,o!==this.current&&(this.current=o,this.fn&&this.fn(this.current),!0)},e.update=function(e){if(this.mode===t.POSITION){var o=this.currentSpeed*this.currentSpeed/(this.speed*this.speedMult*4);Math.abs(this.target-this.current)<=o&&(this.mode=t.STOP)}var n=this.mode===t.STOP?0:this.speed*this.speedMult;this.target<this.current&&(n=-n),this.currentSpeed<n?this.currentSpeed=Math.min(n,this.currentSpeed+e/1e3*this.speed*this.speedMult*2):this.currentSpeed>n&&(this.currentSpeed=Math.max(n,this.currentSpeed-e/1e3*this.speed*this.speedMult*2));var i=null;return this.current>this.target&&this.currentSpeed?i=Math.max(this.target,this.current+this.currentSpeed*e/1e3):this.current<this.target&&this.currentSpeed&&(i=Math.min(this.target,this.current+this.currentSpeed*e/1e3)),null!==i&&(i=x(i,this.min,this.max))!==this.current&&(this.current=i,this.fn&&this.fn(this.current),!0)},t}();le.STOP=0,le.INFINITE=1,le.POSITION=2;var pe=function(){function t(t,e){this.fn=e,this.dynamics=t,this.fn&&this.fn(this.current)}var e,o,n,i=t.prototype;return i.setSpeed=function(t){N(this.dynamics,(function(e){e.setSpeed(t)}))},i.goto=function(t,e){var o=this;void 0===e&&(e=1),N(t,(function(t,n){o.dynamics[n].goto(t,e)}))},i.step=function(t,e){var o=this;void 0===e&&(e=1),N(t,(function(t,n){o.dynamics[n].step(t,e)}))},i.roll=function(t,e){var o=this;void 0===e&&(e=1),N(t,(function(t,n){o.dynamics[n].roll(t,e)}))},i.stop=function(){N(this.dynamics,(function(t){return t.stop()}))},i.setValue=function(t){var e=this,o=!1;return N(t,(function(t,n){o|=e.dynamics[n].setValue(t)})),o&&this.fn&&this.fn(this.current),o},i.update=function(t){var e=!1;return N(this.dynamics,(function(o){e|=o.update(t)})),e&&this.fn&&this.fn(this.current),e},e=t,(o=[{key:"current",get:function(){var t={};return N(this.dynamics,(function(e,o){t[o]=e.current})),t}}])&&st(e.prototype,o),n&&st(e,n),Object.defineProperty(e,"prototype",{writable:!1}),t}();e.Cache.enabled=!0;var ue=function(t){function o(o){var n;if(n=t.call(this)||this,_t.load(),!_t.isWebGLSupported)throw new W("WebGL is not supported.");if(0===_t.maxTextureWidth)throw new W("Unable to detect system capabilities");return n.prop={ready:!1,uiRefresh:!1,needsUpdate:!1,fullscreen:!1,direction:new e.Vector3(0,0,i),vFov:null,hFov:null,aspect:null,autorotateEnabled:!1,animationPromise:null,loadingPromise:null,startTimeout:null,objectsObservers:{},size:{width:0,height:0},panoData:{fullWidth:0,fullHeight:0,croppedWidth:0,croppedHeight:0,croppedX:0,croppedY:0,poseHeading:0,posePitch:0,poseRoll:0}},n.config=function(t){var e=z(Rt);H(e,t);var o={};return N(e,(function(t,n){if(Ut[n])Y(Ut[n]);else{if(!Object.prototype.hasOwnProperty.call(Rt,n))throw new W("Unknown option "+n);Ft[n]?o[n]=Ft[n](t,e):o[n]=t}})),o}(o),n.parent="string"==typeof o.container?document.getElementById(o.container):o.container,n.parent[r]=lt(n),n.container=document.createElement("div"),n.container.classList.add("psv-container"),n.parent.appendChild(n.container),n.adapter=new n.config.adapter[0](lt(n),n.config.adapter[1]),n.children=[],n.plugins={},n.renderer=new oe(lt(n)),n.textureLoader=new ne(lt(n)),n.eventsHandler=new ee(lt(n)),n.dataHelper=new te(lt(n)),n.loader=new Xt(lt(n)),n.navbar=new Yt(lt(n)),n.panel=new qt(lt(n)),n.tooltip=new he(lt(n)),n.notification=new Bt(lt(n)),n.overlay=new Gt(lt(n)),n.dynamics={zoom:new le((function(t){n.prop.vFov=n.dataHelper.zoomLevelToFov(t),n.prop.hFov=n.dataHelper.vFovToHFov(n.prop.vFov),n.trigger(c.ZOOM_UPDATED,t)}),n.config.defaultZoomLvl,0,100),position:new pe({longitude:new le(null,n.config.defaultLong),latitude:new le(null,n.config.defaultLat,-Math.PI/2,Math.PI/2)},(function(t){n.dataHelper.sphericalCoordsToVector3(t,n.prop.direction),n.trigger(c.POSITION_UPDATED,n.dataHelper.cleanPosition(t))}))},n.__updateSpeeds(),n.eventsHandler.init(),n.__resizeRefresh=D((function(){return n.refreshUi("resize")}),500),n.resize(n.config.size),n.config.plugins.forEach((function(t){var e=t[0],o=t[1];n.plugins[e.id]=new e(lt(n),o)})),N(n.plugins,(function(t){return null==t.init?void 0:t.init()})),n.navbar.setButtons(n.config.navbar),n.config.panorama&&n.setPanorama(n.config.panorama),_t.isTouchEnabled.then((function(t){return f(n.container,"psv--is-touch",t)})),n.once(c.RENDER,(function(){n.config.navbar&&(n.container.classList.add("psv--has-navbar"),n.navbar.show()),n.config.autorotateDelay&&(n.prop.startTimeout=setTimeout((function(){return n.startAutorotate()}),n.config.autorotateDelay)),n.prop.ready=!0,setTimeout((function(){n.refreshUi("init"),n.trigger(c.READY)}),0)})),n}ct(o,t);var n=o.prototype;return n.destroy=function(){this.__stopAll(),this.stopKeyboardControl(),this.exitFullscreen(),this.eventsHandler.destroy(),this.renderer.destroy(),this.textureLoader.destroy(),this.dataHelper.destroy(),this.adapter.destroy(),this.children.slice().forEach((function(t){return t.destroy()})),this.children.length=0,N(this.plugins,(function(t){return t.destroy()})),delete this.plugins,this.parent.removeChild(this.container),delete this.parent[r],delete this.parent,delete this.container,delete this.loader,delete this.navbar,delete this.panel,delete this.tooltip,delete this.notification,delete this.overlay,delete this.config},n.refreshUi=function(t){var e=this;this.prop.ready&&(this.prop.uiRefresh?"new"!==this.prop.uiRefresh&&(this.prop.uiRefresh="new",setTimeout((function(){e.prop.uiRefresh=!1,e.refreshUi(t)}))):(this.prop.uiRefresh=!0,this.children.every((function(t){return t.refreshUi(),!0===e.prop.uiRefresh})),this.prop.uiRefresh=!1))},n.getPlugin=function(t){if("string"==typeof t)return this.plugins[t];var e=V(t,zt);return e?this.plugins[e.id]:void 0},n.getPosition=function(){return this.dataHelper.cleanPosition(this.dynamics.position.current)},n.getZoomLevel=function(){return this.dynamics.zoom.current},n.getSize=function(){return at({},this.prop.size)},n.isAutorotateEnabled=function(){return this.prop.autorotateEnabled},n.isFullscreenEnabled=function(){return _t.fullscreenEvent?b(this.container):this.prop.fullscreen},n.needsUpdate=function(){this.prop.needsUpdate=!0},n.autoSize=function(){this.container.clientWidth===this.prop.size.width&&this.container.clientHeight===this.prop.size.height||(this.prop.size.width=Math.round(this.container.clientWidth),this.prop.size.height=Math.round(this.container.clientHeight),this.prop.aspect=this.prop.size.width/this.prop.size.height,this.prop.hFov=this.dataHelper.vFovToHFov(this.prop.vFov),this.trigger(c.SIZE_UPDATED,this.getSize()),this.__resizeRefresh())},n.setPanorama=function(t,e){var o,n=this;void 0===e&&(e={}),this.textureLoader.abortLoading(),null==(o=this.prop.transitionAnimation)||o.cancel(),this.prop.ready||("sphereCorrection"in e||(e.sphereCorrection=this.config.sphereCorrection),"panoData"in e||(e.panoData=this.config.panoData)),void 0!==e.transition&&!0!==e.transition||(e.transition=1500),void 0===e.showLoader&&(e.showLoader=!0),void 0===e.caption&&(e.caption=this.config.caption);var i=X(e),r="zoom"in e;(i||r)&&this.__stopAll(),this.hideError(),this.config.panorama=t,this.config.caption=e.caption;var s=function(t){if(n.loader.hide(),n.prop.loadingPromise=null,j(t))return!1;if(t)throw n.navbar.setCaption(""),n.showError(n.config.lang.loadError),console.error(t),t;return n.navbar.setCaption(n.config.caption),!0};this.navbar.setCaption("<em>"+(this.config.loadingTxt||"")+"</em>"),!e.showLoader&&this.prop.ready||this.loader.show();var a=this.adapter.loadTexture(this.config.panorama,e.panoData).then((function(t){if(t.panorama!==n.config.panorama)throw n.adapter.disposeTexture(t),Z();return t}));return e.transition&&this.prop.ready&&this.adapter.supportsTransition(this.config.panorama)?this.prop.loadingPromise=a.then((function(t){return n.loader.hide(),n.prop.transitionAnimation=n.renderer.transition(t,e),n.prop.transitionAnimation.then((function(t){if(n.prop.transitionAnimation=null,!t)throw Z()}))})).then(s,s):this.prop.loadingPromise=a.then((function(t){n.renderer.show(),n.renderer.setTexture(t),n.renderer.setPanoramaPose(t.panoData),n.renderer.setSphereCorrection(e.sphereCorrection),r&&n.zoom(e.zoom),i&&n.rotate(e)})).then(s,s),this.prop.loadingPromise},n.setOptions=function(t){var e=this;N(t,(function(o,n){if(Ut[n])Y(Ut[n]);else{if(!Object.prototype.hasOwnProperty.call(Rt,n))throw new W("Unknown option "+n);if(Nt[n])throw new W(Nt[n]);switch(Ft[n]?e.config[n]=Ft[n](o,t):e.config[n]=o,n){case"caption":e.navbar.setCaption(o);break;case"size":e.resize(o);break;case"sphereCorrection":e.renderer.setSphereCorrection(o);break;case"navbar":case"lang":e.navbar.setButtons(e.config.navbar);break;case"moveSpeed":case"zoomSpeed":e.__updateSpeeds();break;case"minFov":case"maxFov":e.dynamics.zoom.setValue(e.dataHelper.fovToZoomLevel(e.prop.vFov)),e.trigger(c.ZOOM_UPDATED,e.getZoomLevel());break;case"canvasBackground":e.renderer.canvasContainer.style.background=e.config.canvasBackground}}})),this.needsUpdate(),this.refreshUi("set options"),this.trigger(c.CONFIG_CHANGED,Object.keys(t))},n.setOption=function(t,e){var o;this.setOptions(((o={})[t]=e,o))},n.startAutorotate=function(t){void 0===t&&(t=!1),t&&!this.isAutorotateEnabled()||(t||this.__stopAll(),this.dynamics.position.roll({longitude:this.config.autorotateSpeed<0},Math.abs(this.config.autorotateSpeed/this.config.moveSpeed)),this.dynamics.position.goto({latitude:this.config.autorotateLat},Math.abs(this.config.autorotateSpeed/this.config.moveSpeed)),this.prop.autorotateEnabled=!0,t||this.trigger(c.AUTOROTATE,!0))},n.stopAutorotate=function(){this.prop.startTimeout&&(clearTimeout(this.prop.startTimeout),this.prop.startTimeout=null),this.isAutorotateEnabled()&&(this.dynamics.position.stop(),this.prop.autorotateEnabled=!1,this.trigger(c.AUTOROTATE,!1))},n.toggleAutorotate=function(){this.isAutorotateEnabled()?this.stopAutorotate():this.startAutorotate()},n.showError=function(t){this.overlay.show({id:p.ERROR,image:'<svg xmlns="http://www.w3.org/2000/svg" viewBox="15 15 70 70"><path fill="currentColor" d="M50,16.2c-18.6,0-33.8,15.1-33.8,33.8S31.4,83.7,50,83.7S83.8,68.6,83.8,50S68.6,16.2,50,16.2z M50,80.2c-16.7,0-30.2-13.6-30.2-30.2S33.3,19.7,50,19.7S80.3,33.3,80.3,50S66.7,80.2,50,80.2z"/><rect fill="currentColor" x="48" y="31.7" width="4" height="28"/><rect fill="currentColor" x="48" y="63.2" width="4" height="5"/>\x3c!--Created by Shastry from the Noun Project--\x3e</svg>\n',text:t,dissmisable:!1})},n.hideError=function(){this.overlay.hide(p.ERROR)},n.rotate=function(t){if(!this.trigger(c.BEFORE_ROTATE,t).isDefaultPrevented()){var e=this.change(h.GET_ROTATE_POSITION,this.dataHelper.cleanPosition(t));this.dynamics.position.setValue(e)}},n.animate=function(t){var e=this;this.__stopAll();var o,n=X(t),i="zoom"in t,r={};if(n){var s=this.change(h.GET_ANIMATE_POSITION,this.dataHelper.cleanPosition(t)),a=this.getPosition(),c=P(a.longitude,s.longitude);r.longitude={start:a.longitude,end:a.longitude+c},r.latitude={start:a.latitude,end:s.latitude},o=this.dataHelper.speedToDuration(t.speed,S(a,s))}if(i){var l=Math.abs(t.zoom-this.getZoomLevel());r.zoom={start:this.getZoomLevel(),end:t.zoom},o||(o=this.dataHelper.speedToDuration(t.speed,Math.PI/4*l/100))}return o?(this.prop.animationPromise=new rt({properties:r,duration:o,easing:"inOutSine",onTick:function(t){n&&e.rotate(t),i&&e.zoom(t.zoom)}}),this.prop.animationPromise):(n&&this.rotate(t),i&&this.zoom(t.zoom),new rt)},n.stopAnimation=function(){var t=this;return this.prop.animationPromise?new Promise((function(e){t.prop.animationPromise.then(e),t.prop.animationPromise.cancel(),t.prop.animationPromise=null})):Promise.resolve()},n.zoom=function(t){this.dynamics.zoom.setValue(t)},n.zoomIn=function(t){void 0===t&&(t=1),this.dynamics.zoom.step(t)},n.zoomOut=function(t){void 0===t&&(t=1),this.dynamics.zoom.step(-t)},n.resize=function(t){var e=this;["width","height"].forEach((function(o){t&&t[o]&&(/^[0-9.]+$/.test(t[o])&&(t[o]+="px"),e.parent.style[o]=t[o])})),this.autoSize()},n.enterFullscreen=function(){_t.fullscreenEvent?T(this.container):(this.container.classList.add("psv-container--fullscreen"),this.autoSize(),this.eventsHandler.__fullscreenToggled(!0))},n.exitFullscreen=function(){this.isFullscreenEnabled()&&(_t.fullscreenEvent?M():(this.container.classList.remove("psv-container--fullscreen"),this.autoSize(),this.eventsHandler.__fullscreenToggled(!1)))},n.toggleFullscreen=function(){this.isFullscreenEnabled()?this.exitFullscreen():this.enterFullscreen()},n.startKeyboardControl=function(){this.eventsHandler.enableKeyboard()},n.stopKeyboardControl=function(){this.eventsHandler.disableKeyboard()},n.observeObjects=function(t,e){var o=this;return this.prop.objectsObservers[t]={listener:e},function(){delete o.prop.objectsObservers[t]}},n.__stopAll=function(){this.stopAutorotate(),this.stopAnimation(),this.trigger(c.STOP_ALL)},n.__updateSpeeds=function(){this.dynamics.zoom.setSpeed(50*this.config.zoomSpeed),this.dynamics.position.setSpeed(e.Math.degToRad(50*this.config.moveSpeed))},o}(o.EventEmitter);t.AbstractAdapter=Dt,t.AbstractButton=ut,t.AbstractPlugin=zt,t.Animation=rt,t.CONSTANTS=v,t.DEFAULTS=Rt,t.EquirectangularAdapter=It,t.PSVError=W,t.SYSTEM=_t,t.Viewer=ue,t.registerButton=jt,t.utils=it,Object.defineProperty(t,"__esModule",{value:!0})}));